/******************************************************************************

  ecat63.h

  Date:
  1996-10-30 VO
  2002-01-20 VO
  2002-02-01 VO
  2002-02-12 VO
  2002-08-23 VO
  2003-07-21 VO
  2003-08-05 VO
  2003-09-08 VO
  2004-06-27 VO
  2004-12-28 VO


******************************************************************************/
#ifndef _ECAT63_H_
#define _ECAT63_H_
/*****************************************************************************/
#define MatBLKSIZE 512
#define MatFirstDirBlk 2
/* Data types */
#define	BYTE_TYPE   1
#define	VAX_I2      2
#define VAX_I4      3
#define VAX_R4      4
#define IEEE_R4     5
#define	SUN_I2      6
#define	SUN_I4      7
/* File types */
#define	RAW_DATA    1
#define	IMAGE_DATA  2
#define	ATTN_DATA   3
#define	NORM_DATA   4
/*****************************************************************************/
#define ECAT63_SYSTEM_TYPE_DEFAULT 931
/*****************************************************************************/
char ecat63errmsg[128];
/*****************************************************************************/
int ECAT63_TEST;
/*****************************************************************************/

typedef struct {
  int matnum;
  int strtblk;
  int endblk;
  int matstat;
} MatDir;

typedef struct {
  int matrixNr;
  int matrixSpace;
  MatDir *matdir;
} MATRIXLIST;

typedef struct {
  int frame, plane, gate, data, bed;
} Matval;

typedef struct ecat63_mainheader {
  char      ecat_format[14], fill1[14];
  char      original_file_name[20];
  short int sw_version;
  short int data_type;
  short int system_type;
  short int file_type;
  char      node_id[10];
  short int scan_start_day, scan_start_month, scan_start_year,
            scan_start_hour, scan_start_minute, scan_start_second;
  char      isotope_code[8];
  float     isotope_halflife;
  char      radiopharmaceutical[32];
  float     gantry_tilt, gantry_rotation, bed_elevation;
  short int rot_source_speed, wobble_speed, transm_source_type;
  float     axial_fov, transaxial_fov;
  short int transaxial_samp_mode, coin_samp_mode, axial_samp_mode;
  float     calibration_factor;
  short int calibration_units, compression_code;
  char      study_name[12], patient_id[16], patient_name[32], patient_sex,
            patient_age[10], patient_height[10], patient_weight[10],
            patient_dexterity, physician_name[32], operator_name[32],
            study_description[32];
  short int acquisition_type, bed_type, septa_type;
  char      facility_name[20];
  short int num_planes, num_frames, num_gates, num_bed_pos;
  float     init_bed_position, bed_offset[15], plane_separation;
  short int lwr_sctr_thres, lwr_true_thres, upr_true_thres;
  float     collimator;
  char      user_process_code[10];
  short int fill2[20];
} ECAT63_mainheader;

typedef struct ecat63_imageheader {
  char      fill1[126];
  short int data_type, num_dimensions, dimension_1, dimension_2;
  float     x_origin, y_origin, recon_scale, quant_scale;
  short int image_min, image_max;
  float     pixel_size, slice_width;
  int       frame_duration, frame_start_time;
  short int slice_location,
            recon_start_hour, recon_start_min, recon_start_sec;
  int       recon_duration;
  short int filter_code;
  int       scan_matrix_num, norm_matrix_num, atten_cor_mat_num;
  float     image_rotation, plane_eff_corr_fctr,
            decay_corr_fctr, loss_corr_fctr, intrinsic_tilt;
  short int processing_code, quant_units,
            recon_start_day, recon_start_month, recon_start_year;
  float     ecat_calibration_fctr, well_counter_cal_fctr, filter_params[6];
  char      annotation[40];
  short int fill2[26];
} ECAT63_imageheader;

typedef struct ecat63_scanheader {
  char      fill1[126];
  short int data_type,
            dimension_1, dimension_2,
            smoothing, processing_code;
  float     sample_distance,
            isotope_halflife;
  short int frame_duration_sec;
  int       gate_duration, r_wave_offset;
  float     scale_factor;
  short int scan_min, scan_max;
  int       prompts, delayed, multiples, net_trues;
  float     cor_singles[16], uncor_singles[16],
            tot_avg_cor, tot_avg_uncor;
  int       total_coin_rate,
            frame_start_time, frame_duration;
  float     loss_correction_fctr;
  short int fill2[22];
} ECAT63_scanheader;

typedef struct ecat63_normheader {
  short int data_type,
            dimension_1, dimension_2;
  float     scale_factor;
  short int norm_hour, norm_minute, norm_second, norm_day, norm_month, norm_year;
  float     fov_source_width;
} ECAT63_normheader;

typedef struct ecat63_attnheader {
  short int data_type, attenuation_type,
            dimension_1, dimension_2;
  float     scale_factor,
            x_origin, y_origin, x_radius, y_radius, tilt_angle,
            attenuation_coeff,
            sample_distance;
} ECAT63_attnheader;

typedef struct matdirnode {
  int    matnum;
  int    strtblk;
  int    endblk;
  int    matstat;
  struct matdirnode *next;
} MatDirNode ;

typedef struct matdirlist {
  int         nmats;
  MatDirNode *first;
  MatDirNode *last;
} MatDirList;

typedef struct matrixdata {
  int    mat_type;
  char  *shptr;
  char  *data_ptr;
  int    nviews;
  int    nelements;
  int    nblks;
  int    data_type;
} MatrixData ;

typedef struct matrix_file {
  ECAT63_mainheader *mhptr;
  MatDirList *dirlist;
  FILE *fptr ;
} Matrix_file;
/*****************************************************************************/
/* Read functions */
int ecat63ReadMainheader(FILE *fp, ECAT63_mainheader *h);
int ecat63ReadImageheader(FILE *fp, int blk, ECAT63_imageheader *h);
int ecat63ReadScanheader(FILE *fp, int blk, ECAT63_scanheader *h);
int ecat63ReadAttnheader(FILE *fp, int blk, ECAT63_attnheader *h);
int ecat63ReadNormheader(FILE *fp, int blk, ECAT63_normheader *h);
int ecat63ReadMatdata(FILE *fp, int strtblk, int blkNr, char *data, int dtype);
int ecat63ReadImageMatrix(FILE *fp, int strtblk, int lastblk, ECAT63_imageheader *h, float **f);
int ecat63ReadScanMatrix(FILE *fp, int strtblk, int lastblk, ECAT63_scanheader *h, float **f);
float ecat63rFloat(void *bufi, int isvax, int islittle);
int ecat63rInt(void *bufi, int isvax, int islittle);
int ecat63pxlbytes(short int data_type);
/*****************************************************************************/
/* Matrix list functions */
void ecat63InitMatlist(MATRIXLIST *mlist);
void ecat63EmptyMatlist(MATRIXLIST *mlist);
int ecat63ReadMatlist(FILE *fp, MATRIXLIST *ml);
void ecat63PrintMatlist(MATRIXLIST *ml);
int mat_numcod(int frame, int plane, int gate, int data, int bed);
void mat_numdoc(int matnum, Matval *matval);
int ecat63Matenter(FILE *fp, int matnum, int blkNr);
void ecat63SortMatlistByPlane(MATRIXLIST *ml);
void ecat63SortMatlistByFrame(MATRIXLIST *ml);
int ecat63CheckMatlist(MATRIXLIST *ml);
int ecat63DeleteLateFrames(MATRIXLIST *ml, int frame_nr);
/*****************************************************************************/
/* Write functions */
int ecat63WriteMainheader(FILE *fp, ECAT63_mainheader *h);
int ecat63WriteImageheader(FILE *fp, int block, ECAT63_imageheader *h);
int ecat63WriteScanheader(FILE *fp, int block, ECAT63_scanheader *h);
int ecat63WriteAttnheader(FILE *fp, int block, ECAT63_attnheader *h);
int ecat63WriteNormheader(FILE *fp, int block, ECAT63_normheader *h);
FILE *ecat63Create(char *fname, ECAT63_mainheader *h);
int ecat63WriteMatdata(FILE *fp, int strtblk, char *data, int pxlNr, int pxlSize);
int ecat63WriteScan(FILE *fp, int matnum, ECAT63_scanheader *h, void *data);
int ecat63WriteImage(FILE *fp, int matnum, ECAT63_imageheader *h, void *data);
int ecat63WriteNorm(FILE *fp, int matnum, ECAT63_normheader *h, void *data);
int ecat63WriteAttn(FILE *fp, int matnum, ECAT63_attnheader *h, void *data);
int ecat63WriteImageMatrix(FILE *fp, int matnum, ECAT63_imageheader *h, float *fdata);
int ecat63WriteScanMatrix(FILE *fp, int matnum, ECAT63_scanheader *h, float *fdata);
void ecat63wFloat(float *bufi, void *bufo, int tovax, int islittle);
void ecat63wInt(int *bufi, void *bufo, int tovax, int islittle);
int ecat63_is_scaling_needed(float amax, float *data, int nr);
/*****************************************************************************/
/* Printing functions */
void ecat63PrintMainheader(ECAT63_mainheader *h);
void ecat63PrintImageheader(ECAT63_imageheader *h);
void ecat63PrintScanheader(ECAT63_scanheader *h);
void ecat63PrintAttnheader(ECAT63_attnheader *h);
void ecat63PrintNormheader(ECAT63_normheader *h);
char *ecat63Datatype(short int dtype);
char *ecat63Unit(short int dunit);
void float2parts(float *buf);
/*****************************************************************************/
#endif

