/******************************************************************************
  Copyright (c)  2003,2004 by Turku PET Centre

  imgfile.h - definitions for imgfile.c

  Version:
  2003-07-17 Vesa Oikonen
  2003-07-21 VO
  2003-07-25 VO
  2003-07-26 VO
  2003-09-04 VO
  2003-10-04 VO
  2004-09-24 VO


******************************************************************************/
#ifndef _IMGFILE_H
#define _IMGFILE_H
/*****************************************************************************/
#include "ecat7.h"
/*****************************************************************************/
int imgRead(char *fname, IMG *img);
int imgWrite(char *fname, IMG *img);
/*****************************************************************************/
int ecat63ReadAllToImg(char *fname, IMG *img);
int ecat63WriteAllImg(char *fname, IMG *img);
int ecat63ReadPlaneToImg(char *fname, IMG *img);
int ecat63AddImg(char *fname, IMG *img);
/*****************************************************************************/
int imgReadEcat7(char *fname, IMG *img);
int imgWriteEcat7(char *fname, IMG *img);
int imgWrite2DEcat7(char *fname, IMG *img);
/*****************************************************************************/
void imgGetEcat7MHeader(IMG *img, ECAT7_mainheader *h);
void imgSetEcat7MHeader(IMG *img, ECAT7_mainheader *h);
void imgUnitFromEcat(IMG *img, int ecat_unit);
void imgUnitFromEcat7(IMG *img, ECAT7_mainheader *h);
int imgUnitToEcat6(IMG *img);
void imgUnitToEcat7(IMG *img, ECAT7_mainheader *h);
/*****************************************************************************/
int imgReadAnalyze(char *dbname, IMG *img);
int imgWriteAnalyze(char *dbname, IMG *img);
/*****************************************************************************/
#endif /* _IMGFILE_H */

