/******************************************************************************
  Copyright (c)  2003,2004 by Turku PET Centre

  imgproc.h - definitions for imgproc.c

  Version:
  2003-07-01 Vesa Oikonen
  2003-07-07 VO
  2003-08-04 VO
    Included new scanner types.
  2003-09-30 VO
  2003-10-04 VO
  2003-10-13 VO
  2003-12-03 VO
  2003-12-14 VO
    Scanner type definitions moved into img.h.
  2003-12-18 VO
  2004-07-18 VO
  2004-07-20 VO


******************************************************************************/
#ifndef _IMGPROC_H
#define _IMGPROC_H
/*****************************************************************************/
int imgArithm(IMG *img1, IMG *img2, char operation, float ulimit);
int imgArithmConst(IMG *img, float operand, char operation, float ulimit);
int imgArithmFrame(IMG *img1, IMG *img2, char operation, float ulimit);
int imgThresholdTemplate(IMG *img, float minValue, float maxValue, IMG *timg);
int imgThresholdByTemplate(IMG *img, IMG *template, float thrValue);
int imgAverageTAC(IMG *img, float *tac);
int imgAverageTemplateTAC(IMG *img, IMG *timg, float *tac);
int imgAverageAUC(IMG *img, float *avgauc);
int imgLog10(IMG *img);
int imgMax(IMG *img, float *maxvalue);
int imgAbsMax(IMG *img, float *maxvalue);
int imgMinMax(IMG *img, float *minvalue, float *maxvalue);
int imgFrameMinMax(IMG *img, int frame, float *minvalue, float *maxvalue);
int imgFrameIntegral(IMG *img, int first, int last, IMG *iimg);
int imgRawCountsPerTime(IMG *img, int operation);
void imgFlipHorizontal(IMG *img);
void imgFlipVertical(IMG *img);
void imgFlipPlanes(IMG *img);
int imgSetScanner(IMG *img, int scanner_type);
/*****************************************************************************/

/*****************************************************************************/
#endif /* _IMGPROC_H */

