/******************************************************************************
  Copyright (c)  2001-2004 by Turku PET Centre

  mathfunc.h

  Version:
  2001-10-04 Vesa Oikonen
  2003-02-19 VO
  2003-08-14 VO
  2004-09-20 VO
    Changed the comments to doxygen style.

******************************************************************************/
#ifndef _MATHFUNC_H
#define _MATHFUNC_H
/*****************************************************************************/
#define FIT_VER "FIT1"
/*****************************************************************************/
/* Missing data */
#ifndef NA
#define NA -99000.
#endif
/* Max nr of parameters */
#ifndef MAX_FITPARAMS
#define MAX_FITPARAMS 20
#endif
/*****************************************************************************/
int MATHFUNC_TEST;
/*****************************************************************************/
char fiterrmsg[64];
/*****************************************************************************/
/*
 *  Data structure definitions
 */

/** Definitions for one curve */
typedef struct {
  /** Name of the curve */
  char      voiname[7], hemisphere[7], place[7];
  /** Number (type) of function */
  int       type;
  /** The number of parameters */
  int       parNr;
  /** Fit start time */
  double    start;
  /** Fit end time */
  double    end;
  /** Number of data points in the fit */
  int       dataNr;
  /** Fitted parameters */
  double    p[MAX_FITPARAMS];
  /** (weighted) sum-of-squares */
  double    wss;
  /** Temporary switches for outside procedures */
  char      sw, sw2, sw3;
} FitVOI;

/** Definitions for a set of curves */
typedef struct {
  /** Number of regions */
  int       voiNr;
  /** Name of original datafile */
  char      datafile[1024];
  /** Unit of concentration */
  char      unit[13];
  /** Time unit: 0=min, 1=sec, 11=um, 12=mm, -1=unknown */
  int       timeunit;
  /** Pointers to regional curves */
  FitVOI   *voi;
  /** Fit date and time */
  time_t    time;
  /** Program name */
  char      program[1024];
  /** Internal variables: Number of allocated curves (VOIs) */
  int      _voidataNr; /*  */
} FIT;
/*****************************************************************************/
void emptyFIT(FIT *fit);
void initFIT(FIT *fit);
int setmemFIT(FIT *fit, int voiNr);
void printFIT(FIT *fit);
int writeFIT(FIT *fit, char *filename);
int readFIT(char *filename, FIT *fit);
int evalFIT(FitVOI *r, double x, double *y);
int evaltacFIT(FitVOI *r, double *x, double *y, int dataNr);
int functionnameFIT(int type, char *str);
int functionformatFIT(int type, char *str);
int ievalFIT(FitVOI *r, double x, double *yi);
int ievaltacFIT(FitVOI *r, double *x, double *yi, int dataNr);
int devalFIT(FitVOI *r, double x, double *yd);
int devaltacFIT(FitVOI *r, double *x, double *yd, int dataNr);
/*****************************************************************************/
#endif

