/******************************************************************************
  Copyright (c) 2003 by Turku PET Centre
 
  qr.h
 
  Version:
  2003-08-28 Kaisa Sederholm
  2003-09-10 KS
  Added variables wws, ws, cchain, chain and help
 
******************************************************************************/
#ifndef _QR_H
#define _QR_H
/*****************************************************************************/
int qr( double **A, int m, int n, double *B, double *X,  double *rnorm,
        double *tau, double *res, double **wws, double *ws);

int qr_decomp (double **a, int M, int N, double *tau, double **cchain, 
               double *chain);

int qr_solve(double **QR, int M, int N, double *tau, double *b, double *x,
             double *residual, double *resNorm, double **cchain,
             double *chain);

int qr_QTvec (double **QR, double *tau, double *v, double *help);

int qr_Qvec (double **QR, double *tau, double *v, double *help);

int qr_invRvec(double **A, double *X);

int qr_weight(int N, int M, double **A, double *b, double *weight);

/*****************************************************************************/
#endif

