/******************************************************************************
  Copyright (c)  1996-2004 by Turku PET Centre

  roi.h - definitions for roi.c

  Version:
  1996-10-08 Vesa Oikonen
  2002-02-09 VO
  2002-11-22 Anne Seppnen
  2003-03-07 AS
  2003-07-02 CL
  2004-09-20 VO
    Changed the comments to doxygen style.
  2004-11-25 CL


******************************************************************************/
#ifndef _ROI_H
#define _ROI_H
/*****************************************************************************/
extern char roierrmsg[128];
/*****************************************************************************/
/* Definitions for ROI types */
#define ROI_RECTANGULAR 0
#define ROI_CIRCULAR 1
#define ROI_ELLIPSE 2
#define ROI_TRACE 3
/*****************************************************************************/
/* ROI data structure */
typedef struct {
  /** Image file for which the ROIs have been defined */
  char imgfile[FILENAME_MAX];
  /** Zoom of the image when drawing */
  float zoom;
  /** Image reconstruction zoom */
  float recon_zoom;
  /** Matrix number (plane and frame) where ROI was defined */
  int matnum;
  /** Type of ROI (rectangular, circular,...) */
  int type;
  /** ROI status */
  int status;
  /** ROI initial point x */
  int pos_x;
  /** ROI initial point y */
  int pos_y;
  /** ROI width & height for other than trace ROIs */
  int w, h, t;
  /** Number of ROI */
  int roi;
  /** ROI name as specified when drawing */
  char roiname[256];
  /** ROI line definition for trace ROIs */
  int *x, *y, point_nr;
  /** User data */
  void *userdata;
} ROI;

/** A linked list for ROIs */
typedef struct _RoiList {
  ROI *roi;
  struct _RoiList *next,*prev;
} RoiList;

/** Definition for a set of ROIs */
typedef struct {
  /** List of the rois */
  RoiList *rois;
  /** Number of ROIs in list; Deprecated, use the above linked list instead */
  int nr;
  /** Allocated memory for _allocNr ROIs*/
  int _allocNr;
  /** Linkd list for ROIs */
  ROI *roi;
} ROI_list;

/*****************************************************************************/

/* Return libpet roi module version */
extern const char *libpet_roi_version(void);

/* Initialize a ROI_list structure */
extern void roi_init(ROI_list *rl);

/* Delete all ROIs from a ROI_list */
extern void roi_empty(ROI_list *rl);

/* Delete a single ROI from ROI_list, pointed by pointer *roi */
extern void roi_delete(ROI_list *rl,ROI *roi);

/* Delete a single ROI from ROI_list, pointed by index number */
extern void roi_delete_n(ROI_list *rl,int index);

/* Read ROIs from file. They are appended to ROI_list  */
extern int roi_read(const char *fname,ROI_list *rl);

/* Save all ROIs from ROI_list overwriting the existing file */
extern int roi_save(char *fname, ROI_list *rl); 

/* Append a single ROI into stream *fp */
extern int roi_append(FILE *fp,ROI *roi);

/* Append a single ROI to stream *fp from ROI_list, pointed by index. (indexes start from 0 */
extern int roi_append_n(FILE *fp, ROI_list *rl, int ind); 

extern int roi_onoff(ROI *roi,int dimx,int dimy,float zoom,char **m);

extern int roi_compute_rect(ROI *roi);
extern int roi_compute_circle(ROI *roi);
extern int roi_compute_ellipse(ROI *roi);
extern void roi_print(ROI *roi);
extern int jsqrt(int n);
extern int roi_mplane(int matnum);
extern int roi_mframe(int matnum);

/* Deprecated functions. Please don't use these anymore */
#define roiEmpty roi_empty
#define roiInit roi_init
extern void roiDel(ROI_list *rl, int ind); /* Delete one ROI from list, */
extern int roiComputeRect(ROI *roi);
extern int roiComputeCirc(ROI *roi);
extern int roiComputeElli(ROI *roi);

#define roiPrint roi_print
#define roiMPlane roi_mplane
#define roiMFrame roi_mframe
extern int roiRead(const char *fname, ROI_list *rl);
extern int roiFillGaps(int *x, int *y, int nr, int **ffx, int **ffy);
extern int roiOnOff(ROI *roi,int dimx,int dimy,float zoom,char **m);

int roiSave(char *fname, ROI_list *rl); /* Save all ROIs in list */
int roiAppend(char *fname, ROI_list *rl, int ind); 
/*****************************************************************************/
#endif

