/******************************************************************************
  Copyright (c)  2001-2005 by Turku PET Centre

  dft.h

  Date:
  2001-03-25 Vesa Oikonen
  2003-06-19 VO
  2003-08-13 VO
  2003-12-05 KS & VO
  2004-01-26 VO
  2004-05-23 VO
    Doxygen style comments.
  2004-05-25 VO
  2004-07-26 VO
    Better Doxygen style comments.
  2004-08-17 VO
  2004-08-23 VO
    Function names with *DFT end changed to start with dft*.
    MAX_STUDYNR_LEN applied.
  2004-09-05 VO
    Field "name" added to Voi struct.
  2004-12-09 VO
    See dft.c.
  2005-10-30 VO
    Introduces dft_fill_hdr_from_IFT().
    Added to DFT the fields radiopharmaceutical, isotope,
    decayCorrected, scanStartTime, and injectionTime.


******************************************************************************/
#ifndef _DFT_H
#define _DFT_H
/*****************************************************************************/
#include "studynr.h"
#include "ift.h"
/*****************************************************************************/
#define DFT_VER "DFT1"
#define _DFT_COMMENT_LEN 16384
/*****************************************************************************/
/* Missing data */
#ifndef NA
#define NA -99000.
#endif
/*****************************************************************************/
char dfterrmsg[64];
/*****************************************************************************/
/*
 *  Data structure definitions
 */

/** Definitions for one curve */
typedef struct {
  /* Name of curve */
  /** Name of region, including hemispehere, plane etc;
      this will replace the voiname, hemisphere and place. */
  char          name[MAX_REGIONNAME_LEN+1];
  /** Name of region */
  char          voiname[7];
  /** dx/sin/avg */
  char          hemisphere[7];
  /** Image plane or other description */
  char          place[7];
  /** Volume of region (mm x mm x mm by default) */
  double        size;
  /* Pointer to curve data and two modified curves */
  /** Pointer to original TAC */
  double       *y;
  /** Pointer to 1st modified TAC (for user) */
  double       *y2;
  /** Pointer to 2nd modified TAC (for user) */
  double       *y3;
  /** Temporary switches for outside procedures */
  char          sw, sw2, sw3;
  } Voi;

/* Definitions for a set of curves */
typedef struct {
  /* Number of data frames (points), and number of planes (curves) */
  /** Nr of samples (frames) in each TAC */
  int           frameNr;
  /** Nr of regional TACs */
  int           voiNr;
  /** Name of study (study number) */
  char          studynr[MAX_STUDYNR_LEN+1];
  /* Units */
  /** Unit of y values */
  char          unit[13];
  /** Unit of x values: 0=min, 1=sec, 11=um, 12=mm */
  int           timeunit;
  /* Study information */
  /** Name of radiopharmaceutical */
  char          radiopharmaceutical[32];
  /** Isotope */
  char          isotope[7];
  /** Decay correction: 0=not known, 1=corrected, 2=not corrected */
  char          decayCorrected;
  /** Scan start date and time: YYYY-MM-DD hh:mm:ss */
  char          scanStartTime[20];
  /** Tracer injection date and time: YYYY-MM-DD hh:mm:ss */
  char          injectionTime[20];
  /* Specified frame time */
  /** Available frame times: 0=middle, 1=start, 2=end, 3=start&end times */
  int           timetype;
  /* Pointers to time values */
  /** Middle frame time */
  double       *x;
  /** Frame start time  */
  double       *x1;
  /** Frame end time    */
  double       *x2;
  /** Pointers to curves */
  Voi          *voi;
  /** Pointer to weight factors */
  double       *w;
  /** Variable indicating whether weights are present */
  int           isweight;
  /** String for comments */
  char         comments[_DFT_COMMENT_LEN];
  /* Internal variables for DFT procedures */
  /** Internal variable: Size of allocated memory (doubles) */
  int           _dataSize;
  /** Internal variable: Pointer to memory */ 
  double       *_data;
  /** Internal variable: Number of allocated curves (VOIs)*/
  int           _voidataNr;
  /** Internal variable: 0=plain datafile, 1=normal DFT */
  int           _type;
  } DFT;
  
/*****************************************************************************/
int dftRead(char *filename, DFT *data);
int dftWrite(DFT *data, char *filename);
void dftInit(DFT *data);
void dftEmpty(DFT *data);
void dftPrint(DFT *data);
int dftType(FILE *fp);
int dftSetmem(DFT *data, int frameNr, int voiNr);
int dftAddmem(DFT *data, int voiNr);
int dftAdd(DFT *data1, DFT *data2, int voi);
int dftSelect(DFT *data, char *name);
int dftSelectRegions(DFT *dft, char *region_name, int reset);
void dftMin2sec(DFT *data);
void dftSec2min(DFT *data);
void dftFrametimes(DFT *data);
int dftOverflow(DFT *data);
int dftCopyvoi(DFT *data, int from, int to);
int dftMovevoi(DFT *dft, int from, int to);
int dftDelete(DFT *dft, int voi);
int dftCopymainhdr(DFT *dft1, DFT *dft2);
int dftCopyvoihdr(DFT *dft1, int from, DFT *dft2, int to);
int dftdup(DFT *dft1, DFT *dft2);
int dftAddnullframe(DFT *data);
int dftSort(DFT *data);
int dftSortPlane(DFT *data);
int dftNAfill(DFT *dft);
double dft_kBqMin(DFT *data);
double dft_kBqMax(DFT *data);
int dftSortByFrame(DFT *dft);
int dftWriteHTML(DFT *dft, char *fname, int orientation);
int dft_fill_hdr_from_IFT(DFT *dft, IFT *ift);
/*****************************************************************************/
/* Deprecated functions. Please don't use these anymore */
#define readDFT dftRead
#define writeDFT dftWrite
#define initDFT dftInit
#define emptyDFT dftEmpty
#define printDFT dftPrint
#define setmemDFT dftSetmem
#define addmemDFT dftAddmem
#define addDFT dftAdd
#define selectDFT dftSelect
#define min2secDFT dftMin2sec
#define sec2minDFT dftSec2min
#define frametimesDFT dftFrametimes
#define overflowDFT dftOverflow
#define copyvoiDFT dftCopyvoi
#define copymainhdrDFT dftCopymainhdr
#define copyvoihdrDFT dftCopyvoihdr
#define addnullframeDFT dftAddnullframe
#define sortDFT dftSort
#define na_fillDFT dftNAfill
#define kBqMinDFT dft_kBqMin
#define kBqMaxDFT dft_kBqMax
/*****************************************************************************/
#endif

