/******************************************************************************
  Copyright (c) 2002-2006 Turku PET Centre

  result.h

  Version:
  2002-08-14 Vesa Oikonen
  2002-10-10 VO
  2002-11-13 VO
  2003-01-18 VO
    Added CL's and SD's for each result parameter.
    MAX_RESPARAMS changed from 20 to 30.
  2003-12-02 VO
    Filename lengths defined with FILENAME_MAX.
    Added fields for tissue density, lumped constant, and plasma concentration.
  2004-01-26 VO
    Added field for beta.
  2004-07-12 VO
    Added field for Vb.
    Doxygen style comments.
  2004-07-26 VO
    Comment style changes.
  2004-08-17 VO
    Added sw2.
  2004-08-23 VO
    MAX_STUDYNR_LEN applied.
  2006-06-03 VO
    Field "name" added to ResVOI struct.
    Added text field for units of parameters.

******************************************************************************/
#ifndef _RESULT_H
#define _RESULT_H
/*****************************************************************************/
#include "studynr.h"
/*****************************************************************************/
/* Missing data */
#ifndef NA
#define NA -99000.
#endif
/* Max nr of parameters */
#ifndef MAX_RESPARAMS
#define MAX_RESPARAMS 30
#endif
/*****************************************************************************/
int RESULT_TEST;
/*****************************************************************************/
char reserrmsg[64];
/*****************************************************************************/
/*
 *  Data structure definitions
 */
/* Definitions for one region */
typedef struct {
  /* Name of the curve */
  /** Name of region, including hemispehere, plane etc;
      this will some day replace the voiname, hemisphere and place. */
  char      name[MAX_REGIONNAME_LEN+1];
  /** Name of region */
  char      voiname[7];
  /** dx/sin/avg */
  char      hemisphere[7];
  /** Image plane or other description */
  char      place[7];
  /* Parameters and their SD's and CL's*/
  /** Array of result values */
  double    parameter[MAX_RESPARAMS];
  /** Array of result SD's   */
  double    sd[MAX_RESPARAMS];
  /** Lower 95% confidence interval */
  double    cl1[MAX_RESPARAMS];
  /** Upper 95% confidence interval */
  double    cl2[MAX_RESPARAMS];
  /** Temporary switches for user */
  int       sw, sw2;
} ResVOI;

/* Definitions for a set of regions */
typedef struct {
  /** Program that produced the results */
  char      program[1024];
  /** Calculation date and time */
  time_t    time;
  /** Number of regions */
  int       voiNr;
  /** Number of parameters, <=MAX_RESPARAMS */
  int parNr;
  /** Name of study (study number) */
  char      studynr[MAX_STUDYNR_LEN+1];
  /* Names of original datafiles */
  /** Name of original tissue datafile */
  char      datafile[FILENAME_MAX];
  /** Name of original ref datafile */
  char      reffile[FILENAME_MAX];
  /** Name of original plasmafile */
  char      plasmafile[FILENAME_MAX];
  /** Name of original bloodfile */
  char      bloodfile[FILENAME_MAX];
  /** Name of reference region */
  char      refroi[64];
  /** Free field describing fit time range */
  char      datarange[128];
  /* Parameters affecting the results */
  /** 0=Data was not weighted, 1=Data was weighted */
  int       isweight;
  /** Tissue density (g/ml) */
  double    density;
  /** Lumped Constant (unitless) */
  double    lc;
  /** Beta */
  double    beta;
  /** Plasma concentration of native substrate, e.g. glucose */
  double    concentration;
  /** Vb percentage */
  double    Vb;
  /** Parameter names separated by space(s) */
  char      titleline[1024];
  /** Parameter units separated by space(s) */
  char      unitline[1024];
  /** Pointers to regional curves */
  ResVOI   *voi;
  /* Internal variables for RESULT procedures */
  /** Internal variable: Number of allocated curves (VOIs); do not change */
  int      _voidataNr;
} RES;
/*****************************************************************************/
void resEmpty(RES *res);
void resInit(RES *res);
int resSetmem(RES *res, int voiNr);
void resPrint(RES *res);
int resRead(char *filename, RES *res);
int resWrite(RES *res, char *filename);
int resWriteHTML(RES *res, char *fname);
int resFName2study(char *fname, char *studyNumber);
int resMedian(double *data, int nr, double *median, double *min, double *max);
int resMean(double *data, int nr, double *mean, double *sd);
void resSortByName(RES *res);
int resCopyMHeader(RES *res1, RES *res2);
int resDelete(RES *res, int voi);
int resSelect(RES *data, char *name);
/*****************************************************************************/
#endif

