/**
   Copyright (c) 2004-2006 by Turku PET Centre

   File: libtpccurveio.c

   Purpose: methods for testing functions in the library libtpccurveio,
   and for printing out libtpccurveio information, such as Readme,
   History and build information.

   NOTICE! This program should always have the same version with the
   library.

   Version:

   2005-04-26 1.1.0 Jarkko Johansson
   2005-06-17 1.1.1 Kaisa Sederholm
   2005-11-30 1.2.1 Vesa Oikonen
   2005-12-05 1.2.2 KS
   2006-01-31 1.2.3 VO
   2006-05-15 1.2.4 VO
   2006-06-03 1.2.5 VO

*/
/*****************************************************************************/
/** Library name */
#define LIB_NAME "libtpccurveio"

/** Serial numbers for function names. */
#define DFTWRITE 1
/*****************************************************************************/
#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include <time.h>
#include <string.h>
#include <ctype.h>
#include <unistd.h>
/*****************************************************************************/
#include <img.h>
#include "libtpccurveiov.h"
/*****************************************************************************/
#define MAXVAL 100000;
/*****************************************************************************/

// Test function declarations:

/**
    Function for printing the usage information of the libtpccurveio test program.
*/
void print_usage();

// Verbose mode switch:
int VERBOSE = 0;

int main (int argc, char *argv[ ])
{
    int c;
    int errflg=0, functionflag=0, exit_code=0;
    //    int  planes1, rows1, columns1, frames1, planes2, rows2, columns2, frames2, zoom=2;
    //    IMG img1, img2;
    //    char filename1[100], filename2[100];
    extern char *optarg;
    extern int optind, optopt;

    while ((c = getopt(argc, argv, "vVbBrRhHf:F:")) != -1) {
      switch (c) {

      case 'V':
      case 'v':
	// Set verbose flag on:
	VERBOSE = 1;
	break;

      case 'B':
      case 'b':
	// Print out the build information:
	libtpccurveio_print_build(stdout);
	return(0);

      case 'r':
	// Print out the Readme message:
	libtpccurveio_print_readme(stdout);
	return(0);
      case 'R':
	// Print out the Readme message with Doxygen tags:
	libtpccurveio_print_dreadme(stdout);
	return(0);

      case 'h':
	// Print out the History message:
	libtpccurveio_print_history(stdout);
	return(0);
      case 'H':
	// Print out the History message with Doxygen tags:
	libtpccurveio_print_dhistory(stdout);
	return(0);

      case 'f':
      case 'F':
	// Set function serial number to be tested:
	functionflag = atoi(optarg);
	break;

      case ':': // -f or -z without argument
	fprintf(stderr,"Option -%c requires an argument\n", optopt);
	errflg++;
	break;
      case '?':
	fprintf(stderr,"Unrecognised option: -%c\n", optopt);
	errflg++;
      }
    }// End parsing command line options...

    if (errflg) {
      print_usage();
      return(2);
    }

    if(!functionflag){
      print_usage();
      return(0);
    }

    libtpccurveio_print_build(stdout);

   //// Choose function(s) to test:
    //switch(functionflag){
    //case DFTWRITE:
    //exit_code = test_dftwrite(&dft);
    //break;
    //default:
    //break;
    //}

    fprintf(stdout,"\n    NO TEST FUNCTION IMPLEMENTATIONS!\n");

    exit(exit_code);
}

//int test_dftwrite(DFT dft){
//printf("\n    Testing dftWrite function...\n");
//dftWrite(&dft);
//}

void print_usage(){

  libtpccurveio_print_build(stdout);
  puts("\n"
       "   Methods for testing functions in the library "LIB_NAME"\n"
       "   and for printing out associated information, such as Readme,\n"
       "   History and build information. \n"
       "\n"
       "   Usage: "LIB_NAME" [-Options]\n"
       "\n"
       "   Options:\n"
       "   -h | H \n"
       "       Print out the "LIB_NAME" History message. Include Doxygen style tags\n"
       "       by using option '-H'.\n"
       "   -r | R \n"
       "       Print out the "LIB_NAME" Readme message. Include Doxygen style tags\n"
       "       by using option '-R'.\n"
       "   -b\n"
       "       Print out the "LIB_NAME" build information.\n"
       "   -f<function serial number>\n"
       "       Runs test procedures for the functions corresponding to given\n"
       "       'function serial number'. Serial numbers are defined in file\n"
       "       libtpccurveio.c.\n"
       "   -v\n"
       "       Run in verbose mode.\n"
       "\n"
       "   E.g.: "LIB_NAME" -h\n"
       "         "LIB_NAME" -v -f 1 \n"
       "\n"
	);

  fflush(stdout);
}

