/******************************************************************************

  libtpccurveiov.c  (c) 2004-2006 Turku PET Centre

  This file contains function for printing the date and time when this library
  is compiled.

  Version:
  2004-11-07 Vesa Oikonen

  2005-01-20 Calle Laakkonen

  2005-04-26 Jarkko Johansson
  Functions libtpccurveio_print_readme(), libtpccurveio_print_history(),
  libtpccurveio_print_dreadme() and libtpccurveio_print_dhistory()
  are used for getting the Readme and History messages for the libtpccurveio,
  with and without Doxygen style tags. Remember to update the
  functions to get correct Readme and History messages!

  Function libtpccurveio_print_build(), is used for getting the build
  information.

  2005-06-17 1.1.1 Kaisa Sederholm
  New version of dft.c
  2005-10-30 1.2.0 VO
  New version of mathfunc.c and mathfunc.h.
  Small addition in result.c.
  2005-11-30 1.2.1 VO
  Added idwc.c and if.c (i/o for Imanet London TAC formats).
  2005-12-05 1.2.2 KS
  Added a warning to dftWrite() in dft.c
  2006-01-31 1.2.3 VO
  Added a function in mathfunc.c.
  2006-05-15 1.2.4 VO
  Bug correction in dft.c.
  2006-06-03 1.2.5 VO
  Added a function in mathfunc.c.
  Added fields in RES structure in result.h and result.c.


******************************************************************************/

/** Library name. */
#define LIB_NAME "libtpccurveio"

/** Library version. */
#define LIB_VERSION "1.2.5"

/** Copyright. */
#define COPYRIGHT "(c) 2004-2006 by Turku PET Centre"

/*****************************************************************************/
#include <stdio.h>
#include "libtpccurveiov.h"
/*****************************************************************************/


/**
    Print the library readme to specified FILE pointer, use stdout for screen.
*/
void libtpccurveio_print_readme(FILE *fp){
  fputs(
	"\n"
	LIB_NAME" "LIB_VERSION" "COPYRIGHT"\n"
	"\n"
	"Build "__DATE__" "__TIME__"\n"
	"\n"
	"\n"
	"PET Curve IO library\n"
	"-------------------------------------------------------------------------------\n"
	"\n"
	"Contents\n"
	"-------------------------------------------------------------------------------\n"
	"\n"
	"include/     - Includes all the header files for the .c files\n"
	"\n"
	"Makefile     - The makefile\n"
	"\n"
	"** .c files **\n"
	"\n"
	"dft.c        -  Reading and writing DFT (TAC) files.\n"
	"\n"
	"mathfunc.c   -  Procedures for FIT files and mathematical functions.\n"
	"\n"
	"ncifile.c    -  Support for previous TAC format (*.roi.kbq/*.roi.nci).\n"
	"\n"
	"result.c     -  Reading and writing result files.\n"
	"\n"
	"cpt.c        -  Functions for reading and writing CPT files.\n"
	"\n"
	"idwc.c       -  Functions for reading and writing IDWC TAC files.\n"
	"\n"
	"if.c         -  Functions for reading and writing IF TAC files.\n"
	"\n"
	"libtpccurveiov.c - Functions for printing the library information.\n"
	"\n"
	"libtpccurveio.c - Program for printing the library information, \n"
	"                  and for testing the library functions.\n"

	"\n"
	"Using the library\n"
	"-------------------------------------------------------------------------------\n"
	"\n"
	"The program that uses the library should include the .h file it needs.\n"
	"Example:\n"
	"    #include <dft.h>\n"
	"\n"
	"	gcc myprog.c -ltpccurveio\n"
	"\n"
	"\n"
	"\n",
	fp
	);

  fflush(fp);
}

/**
    Print the library History to specified FILE pointer,
    use stdout for screen.
*/
void libtpccurveio_print_history(FILE *fp)
{
  fputs(
	"  2004-11-07 Vesa Oikonen\n"
	"\n"
	"  2005-01-20 Calle Laakkonen\n"
	"\n"
	"  2005-04-26 Jarkko Johansson\n"
	"  Functions libtpccurveio_print_readme(), libtpccurveio_print_history(),\n"
	"  libtpccurveio_print_dreadme() and libtpccurveio_print_dhistory()\n"
	"  are used for getting the Readme and History messages for the libtpccurveio,\n"
	"  with and without Doxygen style tags. Remember to update the\n"
	"  functions to get correct Readme and History messages!\n"
	"\n"
	"  Function libtpccurveio_print_build(), is used for getting the build\n"
	"  information.\n"
	"\n"
	"  Merged with libcpt.\n"
        "\n"
	"  2005-06-17 Kaisa Sederholm\n"
	"  New version of dft.c.\n"
	"\n"
	"  2005-10-30 Vesa Oikonen\n"
	"  New version of mathfunc.c, result.c, and dft.c.\n"
	"\n"
	"  2005-11-30 Vesa Oikonen\n"
	"  Added support to Imanet London TAC files (idwc.c and if.c).\n"
	"\n"
	"  2005-12-05 KS\n"
	"  Added warning if the function dftWrite is writing the file \n"
        "  with a name that allready exists.\n"
	"\n"
	"  2006-01-31 VO\n"
	"  New version of mathfunc.c.\n"
        "\n"
	"  2006-05-15 VO\n"
	"  New version of dft.c.\n"
	"\n"
	"  2006-06-03 VO\n"
	"  Added support for Hill function with background (mathfunc.c).\n"
	"  Added fields in result data structure (result.h and result.c).\n"
	"  Field names in result data structure are case-insensitive.\n"
	"  Field names in fit data structure are case-insensitive.\n"
	"\n",
	fp
	);
  fflush(fp);
}

/**
    Print the library Readme to specified FILE pointer with Doxygen tags,
    use stdout for screen.
*/
void libtpccurveio_print_dreadme(FILE *fp)
{
  fprintf(fp,"/**\n\\mainpage %s %s %s\n\\section readme Readme\n<PRE>\n",LIB_NAME,LIB_VERSION,COPYRIGHT);
  libtpccurveio_print_readme(fp);
  fprintf(fp,"\n</PRE> \n */\n");
}

/**
    Print the library History to specified FILE pointer with Doxygen tags,
    use stdout for screen.
*/
void libtpccurveio_print_dhistory(FILE *fp)
{
  fprintf(fp,"/**\n\\page History\n\\section history History\n<PRE>\n");
  libtpccurveio_print_history(fp);
  fprintf(fp,"\n</PRE> \n */\n");
}

/**
    Print the build info to specified FILE pointer, use stdout for screen.
*/
void libtpccurveio_print_build(FILE *fp)
{
  fprintf(fp,"\n %s %s %s\n",LIB_NAME,LIB_VERSION,COPYRIGHT);
  fprintf(fp,"\n Build %s %s\n",__DATE__,__TIME__);
}



/** Print the compilation date and time to specified FILE pointer  */
void libtpccurveio_printdate(FILE *fp)
{
  libtpccurveio_print_build(fp);
}

/*****************************************************************************/

