/******************************************************************************

  ecat63p.c (c) 2003,2004 by Turku PET Centre

  Procedures for printing ECAT 6.3 (header) contents.

  Version: Contents were previously in ecat63.c
  2003-07-21 Vesa Oikonen
  2004-02-08 VO
    ecat63PrintMainheader() prints also sw_version.
  2004-09-20 VO
    Doxygen style comments.


******************************************************************************/
#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include <ctype.h>
#include <string.h>
#include <unistd.h>
#include <time.h>
/*****************************************************************************/
#include <swap.h>
#include "include/ecat63.h"
/*****************************************************************************/

/*****************************************************************************/

/*****************************************************************************/
/** Print ECAT 6.3 mainheader on stdout */
void ecat63PrintMainheader(ECAT63_mainheader *h)
{
  char tmp[32];

  if(ECAT63_TEST) printf("Main header listing for ECAT 6.3 format:\n");
  printf("original_file_name = '%.20s'\n", h->original_file_name);
  strcpy(tmp, ecat63Datatype(h->data_type));
  printf("data_type = %d (%s)  system_type=%d\n", h->data_type, tmp, h->system_type);
  if(h->file_type==1) strcpy(tmp, "sinogram");
  else if(h->file_type==2) strcpy(tmp, "image");
  else if(h->file_type==3) strcpy(tmp, "attenuation");
  else if(h->file_type==4) strcpy(tmp, "normalization");
  else strcpy(tmp, "unknown");
  printf("file_type = %d (%s)\n", h->file_type, tmp);
  printf("sw_version = %d\n", h->sw_version);
  printf("scan start = %02d.%02d.%04d %02d:%02d:%02d\n",
    h->scan_start_day, h->scan_start_month, h->scan_start_year,
    h->scan_start_hour, h->scan_start_minute, h->scan_start_second);
  printf("isotope_code = '%.8s'  isotope_halflife = %g\n",
    h->isotope_code, h->isotope_halflife);
  printf("radiopharmaceutical = '%.32s'\n", h->radiopharmaceutical);
  printf("gantry_tilt = %g  gantry_rotation = %g  bed_elevation = %g\n",
    h->gantry_tilt, h->gantry_rotation, h->bed_elevation);
  printf("axial_fov = %g  transaxial_fov = %g\n",
    h->axial_fov, h->transaxial_fov);
  strcpy(tmp, ecat63Unit(h->calibration_units));
  printf("calibration_factor = %g  calibration_units = %d (%s)\n",
    h->calibration_factor, h->calibration_units, tmp);
  printf("study_name = '%.12s'  patient_id = '%.32s'\n",
    h->study_name, h->patient_id);
  printf("patient_name = '%.32s'\n", h->patient_name);
  printf("sex=%c  age=%.10s  height=%.10s  weigth=%.10s  dexterity=%c\n",
    h->patient_sex, h->patient_age, h->patient_height, h->patient_weight,
    h->patient_dexterity);
  printf("physician_name = %.32s  operator_name = %.32s\n",
    h->physician_name, h->operator_name);
  printf("study_description = %.32s\n", h->study_description);
  printf("%d planes  %d frames  %d gates  %d bed_pos\n",
    h->num_planes, h->num_frames, h->num_gates, h->num_bed_pos);
  printf("init_bed_position = %g\n", h->init_bed_position);
  printf("plane_separation = %g\n", h->plane_separation);
  printf("user_process_code = %.10s\n", h->user_process_code);
}
/*****************************************************************************/

/*****************************************************************************/
/** Print ECAT 6.3 imageheader on stdout */
void ecat63PrintImageheader(ECAT63_imageheader *h)
{
  int i;
  char tmp[32];

  if(ECAT63_TEST) printf("Image subheader listing for ECAT 6.3 format:\n");
  strcpy(tmp, ecat63Datatype(h->data_type));
  printf("data_type = %d (%s) dimension = %dx%d\n",
    h->data_type, tmp, h->dimension_1, h->dimension_2);
  printf("x_origin = %g  y_origin = %g  recon_scale = %g\n",
    h->x_origin, h->y_origin, h->recon_scale);
  printf("quant_scale = %g  image_min = %d  image_max = %d\n",
    h->quant_scale, h->image_min, h->image_max);
  printf("slice_width = %g  pixel_size = %g\n", h->slice_width, h->pixel_size);
  printf("frame_start_time = %d  frame_duration = %d sec\n",
    h->frame_start_time/1000, h->frame_duration/1000 );
  printf("reconstruction start = %02d.%02d.%04d %02d:%02d:%02d\n",
    h->recon_start_day, h->recon_start_month, h->recon_start_year,
    h->recon_start_hour, h->recon_start_min, h->recon_start_sec);
  printf("filter_code = %d  image_rotation = %g  intrinsic_tilt = %g\n",
    h->filter_code, h->image_rotation, h->intrinsic_tilt);
  printf("filter_params:");
  for(i=0; i<6; i++) printf(" %g", h->filter_params[i]); printf("\n");
  printf("plane_eff_corr_fctr= %g  decay_corr_fctr= %g  loss_corr_fctr= %g\n",
    h->plane_eff_corr_fctr, h->decay_corr_fctr, h->loss_corr_fctr);
  strcpy(tmp, ecat63Unit(h->quant_units));
  printf("quant_units = %d (%s)\n", h->quant_units, tmp);
  printf("ecat_calibration_fctr = %g  well_counter_cal_fctr = %g\n",
    h->ecat_calibration_fctr, h->well_counter_cal_fctr);
  printf("annotation = '%.40s'\n", h->annotation);
}
/*****************************************************************************/

/*****************************************************************************/
/** Print ECAT 6.3 scanheader on stdout */
void ecat63PrintScanheader(ECAT63_scanheader *h)
{
  int i;
  char tmp[32];

  strcpy(tmp, ecat63Datatype(h->data_type));
  printf("data_type = %d (%s)  dimension = %dx%d\n",
    h->data_type, tmp, h->dimension_1, h->dimension_2);
  printf("sample_distance = %g cm\n", h->sample_distance);
  printf("isotope_halflife = %g sec\n", h->isotope_halflife);
  printf("gate_duration = %d  r_wave_offset = %d\n",
    h->gate_duration, h->r_wave_offset);
  printf("scale_factor = %g  min = %d  max = %d\n",
    h->scale_factor, h->scan_min, h->scan_max);
  printf("prompts = %d  delayed = %d  multiples = %d  net trues = %d\n",
    h->prompts, h->delayed, h->multiples, h->net_trues);
  printf("cor_singles[]:  (Total singles with loss correction factoring)\n");
  for(i=0; i<16; i++) printf(" %8.0f", h->cor_singles[i]); printf("\n");
  printf("uncor_singles[]:  (Total singles without loss correction factoring)\n");
  for(i=0; i<16; i++) printf(" %8.0f", h->uncor_singles[i]); printf("\n");
  printf("tot_avg_cor=%g  tot_avg_uncor=%g\n", h->tot_avg_cor, h->tot_avg_uncor);
  printf("total_coin_rate=%d  (measured coincidence rate from IPCP)\n", h->total_coin_rate);
  printf("frame_start_time = %d  frame_duration = %d sec\n",
    h->frame_start_time/1000, h->frame_duration/1000 );
  printf("loss_correction_fctr = %g\n", h->loss_correction_fctr);
}
/*****************************************************************************/

/*****************************************************************************/
/** Print ECAT 6.3 attnheader on stdout */
void ecat63PrintAttnheader(ECAT63_attnheader *h)
{
  char tmp[32];

  strcpy(tmp, ecat63Datatype(h->data_type));
  printf("data_type = %d (%s)  dimension = %dx%d  attenuation_type = %d\n",
    h->data_type, tmp, h->dimension_1, h->dimension_2, h->attenuation_type);
  printf("scale_factor = %g\n", h->scale_factor);
  printf("x_origin = %g  y_origin = %g  x_radius = %g  y_radius = %g\n",
    h->x_origin, h->y_origin, h->x_radius, h->y_radius);
  printf("tilt_angle = %g  attenuation_coeff = %g  sample_distance = %g\n",
    h->tilt_angle, h->attenuation_coeff, h->sample_distance);
}
/*****************************************************************************/

/*****************************************************************************/
/** Print ECAT 6.3 normheader on stdout */
void ecat63PrintNormheader(ECAT63_normheader *h)
{
  char tmp[32];

  strcpy(tmp, ecat63Datatype(h->data_type));
  printf("data_type = %d (%s)  dimension = %dx%d\n",
    h->data_type, tmp, h->dimension_1, h->dimension_2);
  printf("scale_factor = %g\n", h->scale_factor);
  printf("norm time = %02d.%02d.%04d %02d:%02d:%02d\n",
    h->norm_day, h->norm_month, h->norm_year,
    h->norm_hour, h->norm_minute, h->norm_second);
}
/*****************************************************************************/

/*****************************************************************************/
/** Return pointer to string describing the ECAT 6.3 data_type */
char *ecat63Datatype(short int dtype)
{
  static char *ecat63_datatype[]={
  /*  0 */  "Unknown",
  /*  1 */  "BYTE_TYPE",
  /*  2 */  "VAX_I2",
  /*  3 */  "VAX_I4",
  /*  4 */  "VAX_R4",
  /*  5 */  "IEEE_R4",
  /*  6 */  "SUN_I2",
  /*  7 */  "SUN_I4",
  /*  8 */  "Unknown",
  /*  9 */  "Unknown"
  };
  if(dtype>=0 && dtype<10) return(ecat63_datatype[dtype]);
  else return(ecat63_datatype[0]);
}

/** Returns pointer to string describing the calibrated data unit (ECAT 6.3) */
char *ecat63Unit(short int dunit)
{
  static char *ecat63_unit[]={
  /*  0 */  "Unknown",
  /*  1 */  "Unknown",
  /*  2 */  "ECAT counts",
  /*  3 */  "uCi/ml",
  /*  4 */  "LMRGlu",
  /*  5 */  "LMRUGlu umol/min/100g",
  /*  6 */  "LMRUGlu mg/min/100g",
  /*  7 */  "nCi/mL",
  /*  8 */  "Well counts",
  /*  9 */  "Becquerels",
  /* 10 */  "kBq/mL",
  /* 11 */  "1/min",
  /* 12 */  "mL/min/100g",
  /* 13 */  "sec*kBq/mL",
  /* 14 */  "sec*nCi/mL",
  /* 15 */  "1/sec",
  /* 16 */  "Unitless",
  /* 17 */  "Unknown"
  };
  if(dunit>=0 && dunit<18) return(ecat63_unit[dunit]);
  else return(ecat63_unit[0]);
}
/*****************************************************************************/
/*  Printfs separately the sign, mantissa, and exp part of a 32-bit float,
 *  which is pointed to by the argument.
 *  Cope is not optimized; do not use this in routine operations!
 */
void float2parts(float *buf)
{
  unsigned int u, exp, mantissa;
  char sign;

  memcpy(&u, buf, 4); if(u & 1L<<31) sign='-'; else sign='+';
  exp=u<<1; exp=exp>>24; mantissa=u<<9; mantissa=mantissa>>9;
  printf("%e = %c (%u/8388608 + 1)*2^(%u-127)\n", *buf, sign, mantissa, exp);
}
/*****************************************************************************/

/*****************************************************************************/

