/******************************************************************************

  Copyright (c) 2003,2004 by Turku PET Centre

  analyze.h

  2003-10-05 VO
  2003-12-05 VO
  2004-09-20 VO


******************************************************************************/
#ifndef _ANALYZE_H
#define _ANALYZE_H
/*****************************************************************************/
#define ANALYZE_HEADER_KEY_SIZE 40
#define ANALYZE_HEADER_IMGDIM_SIZE 108
#define ANALYZE_HEADER_HISTORY_SIZE 200
/*****************************************************************************/
#define ANALYZE_FLIP_DEFAULT 1
/*****************************************************************************/
/* Analyze datatypes */
#define ANALYZE_DT_NONE 0
#define ANALYZE_DT_UNKNOWN 0
#define ANALYZE_DT_BINARY 1
#define ANALYZE_DT_UNSIGNED_CHAR 2
#define ANALYZE_DT_SIGNED_SHORT 4
#define ANALYZE_DT_SIGNED_INT 8
#define ANALYZE_DT_FLOAT 16
#define ANALYZE_DT_COMPLEX 32
#define ANALYZE_DT_DOUBLE 64
#define ANALYZE_DT_RGB 128
#define ANALYZE_DT_ALL 255
/*****************************************************************************/
int ANALYZE_TEST;
/*****************************************************************************/
typedef struct {
  int sizeof_hdr;
  char data_type[10];
  char db_name[18];
  int extents;
  short int session_error;
  char regular;
  char hkey_un0;
} ANALYZE_HEADER_KEY;

typedef struct {
  short int dim[8];
  short int unused8;
  short int unused9;
  short int unused10;
  short int unused11;
  short int unused12;
  short int unused13;
  short int unused14;
  short int datatype;
  short int bitpix;
  short int dim_un0;
  float pixdim[8];
  float vox_offset;
  float funused1;
  float funused2;
  float funused3;
  float cal_max;
  float cal_min;
  float compressed;
  float verified;
  int glmax;
  int glmin;
} ANALYZE_HEADER_IMGDIM;

typedef struct {
  char descrip[80];
  char aux_file[24];
  char orient;
  char originator[10];
  char generated[10];
  char scannum[10];
  char patient_id[10];
  char exp_date[10];
  char exp_time[10];
  char hist_un0[3];
  int views;
  int vols_added;
  int start_field;
  int field_skip;
  int omax;
  int omin;
  int smax;
  int smin;
} ANALYZE_HEADER_HISTORY;

typedef struct {
  ANALYZE_HEADER_KEY hk;
  ANALYZE_HEADER_IMGDIM dime;
  ANALYZE_HEADER_HISTORY hist;
  /** 1=originally little endian, 0=big endian */
  int little;
} ANALYZE_DSR;
/*****************************************************************************/
extern int anaExists(const char *dbname);
extern int anaFlipping();
/*****************************************************************************/
extern int anaReadHeader(char *filename, ANALYZE_DSR *h);
extern int anaReadImagedata(FILE *fp, ANALYZE_DSR *h, int frame, float *data);
/*****************************************************************************/
extern int anaWriteHeader(char *filename, ANALYZE_DSR *h);
/*****************************************************************************/
extern int anaPrintHeader(ANALYZE_DSR *h, FILE *fp);
/*****************************************************************************/
#endif
