/******************************************************************************

  Copyright (c) 2002-2005 by Turku PET Centre

  halflife.h
  
  Reference: Table of Isotopes, Sixth edition, edited by C.M. Lederer,
  J.M. Hollander, I. Perlman. WILEY, 1967.

  Date:
  2002-01-30 Vesa Oikonen
  2002-08-08 VO
    Ga68 changed from 67.8 to 68.0 as requested by Tuula Tolvanen.
  2002-08-28 VO
    Included unofficial isotopes Br76, Rb82 and Cu62.
  2003-07-07 VO
    Included function definitions for halflife.c.
  2004-02-02 VO
    Included unofficial half-lives for Br-75, Cu-64, Fe-52, O-14, Na-22 and
    Zn-62.
  2005-01-21 VO
    Included hlCorrectIsotopeCode().


******************************************************************************/
#ifndef _HALFLIFE_H
#define _HALFLIFE_H
/*****************************************************************************/
/** Isotope halflife in minutes */
#define HL_O15 2.05 /* 123 s */
#define HL_N13 10.0
#define HL_C11 20.4
#define HL_F18 109.8
#define HL_Ge68 396000.0 /* 275 d */
#define HL_Ga68 68.0
/*****************************************************************************/
/* The following halflifes have not been checked from the reference;         */
/* they are thus meant to be used only during program development period     */
#define HL_Br75 98.0
#define HL_Br76 978.33 /* 58700 s */
#define HL_Cu62 9.7    /* 582 s */
#define HL_Cu64 768.0
#define HL_Fe52 4980.0
#define HL_Na22 1368000.0
#define HL_O14 1.1818
#define HL_Rb82 1.25   /* 75 s */
#define HL_Zn62 558.0
/*****************************************************************************/
double hlFromIsotope(char *isocode);
double hl2lambda(double halflife);
double lambda2factor(double lambda, double frametime, double framedur);
char *hlCorrectIsotopeCode(char *isocode);
/*****************************************************************************/
#endif
