/******************************************************************************
  Copyright (c)  2003,2004 by Turku PET Centre

  imgfile.h - definitions for imgfile.c

  Version:
  2003-07-17 Vesa Oikonen
  2003-07-21 VO
  2003-07-25 VO
  2003-07-26 VO
  2003-09-04 VO
  2003-10-04 VO
  2004-09-24 VO


******************************************************************************/
#ifndef _IMGFILE_H
#define _IMGFILE_H
/*****************************************************************************/
#include "ecat7.h"
/*****************************************************************************/
extern int imgRead(const char *fname, IMG *img);
extern int imgReadMainHeader(const char *fname, IMG *img);
extern int imgWrite(const char *fname, IMG *img);
/*****************************************************************************/
extern int ecat63ReadAllToImg(const char *fname, IMG *img);
extern int ecat63WriteAllImg(const char *fname, IMG *img);
extern int ecat63ReadPlaneToImg(const char *fname, IMG *img);
extern int ecat63AddImg(const char *fname, IMG *img);
/*****************************************************************************/
extern int imgReadEcat7(const char *fname, IMG *img);
extern int imgWriteEcat7(const char *fname, IMG *img);
extern int imgWrite2DEcat7(const char *fname, IMG *img);
/*****************************************************************************/
extern void imgGetEcat7MHeader(IMG *img, ECAT7_mainheader *h);
extern void imgSetEcat7MHeader(IMG *img, ECAT7_mainheader *h);
extern void imgUnitFromEcat(IMG *img, int ecat_unit);
extern void imgUnitFromEcat7(IMG *img, ECAT7_mainheader *h);
extern int imgUnitToEcat6(IMG *img);
extern void imgUnitToEcat7(IMG *img, ECAT7_mainheader *h);
/*****************************************************************************/
extern int imgReadAnalyze(const char *dbname, IMG *img);
extern int imgWriteAnalyze(const char *dbname, IMG *img);
/*****************************************************************************/
#endif /* _IMGFILE_H */

