/******************************************************************************

   interfile.h   Turku PET Centre



DATE:
  2005-04-05 (krs) (Roman Krais) 

******************************************************************************/
#ifndef _INTERFILE_H_
#define _INTERFILE_H_
/*****************************************************************************/

/*****************************************************************************
interfile.c:
*****************************************************************************/

/*****************************************************************************
   interfile_read

   SYNTAX:
      int interfile_read(char headerName[256], char searchWord[256], 
                    char returnValue[256], char errorMessage[300])

   DESCRIPTION:
      The function searches the keyword in the header and passes the value
      belonging to that value back to the main program. 
      The name of the header (string 'headerName') and the requested keyword 
      (string 'searchWord') are passed to the function. It passes back the
      value of the keyword (string 'returnValue') and possibly an error message 
      or warning (string 'errorMessage'). So the values are passed back as 
      strings. The interpretation (conversion to integer, float, time etc) 
      is up to the programmer.


      The interfile header has to comply to the following rules:
      - first line in the file is '!INTERFILE'
      - maximal length of a line is 512 characters
      - A line has two fields sperated by ':=' (keyword := value)
      - maximal length of keyword and value is 256 characters.
      - no header entries after a line  '!END OF INTERFILE'
      - a line starting with a semicolon ';' is a comment

   RETURN VALUES:
      0  on success
      1  keyword appears more than once in the interfile header
      2  keyword not found in interfile header
      3  interfile header cold not be opened for reading
      4  wrong file format?! (No '!INTERFILE' in the first line)

   EXAMPLE:
      interfile_read("test.i.hdr","scan start time",value,errmsg);

*****************************************************************************/

int interfile_read(char headerName[256], char searchWord[256], char returnValue[256], char errorMessage[300]);

#endif
