/******************************************************************************

  Copyright (c) 2000-2005 Turku PET Centre

  ift.h

  Modification history:
  2000-12-13 Vesa Oikonen
  2004-08-23 VO
    Doxygen style comments.
    Functions "renamed" with defines.
  2005-01-12 VO
    Changed and additional comments not affecting compiled code.
  2005-01-15 VO
    SIF related stuff moved from libpet to new libsif.
  2005-01-16 VO
    studynr and isotope_name were added to SIF structure.


******************************************************************************/
#ifndef _SIF_H
#define _SIF_H
/*****************************************************************************/
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <math.h>
#include <time.h>
#include <ctype.h>
#include <string.h>
#include <strings.h>
/*****************************************************************************/
char siferrmsg[128];
/*****************************************************************************/
/** Scan Information File Data structure */
typedef struct {
  /** Scan time */
  time_t scantime;
  /** Number of frames */
  int frameNr;
  /** Number of columns (usually 4) */
  int colNr;
  /** SIF version */
  int version;
  /** Studynumber */
  char studynr[11];
  /** String representation of the isotope */
  char isotope_name[8];
  /** Frame start time (sec) */
  double *x1;
  /** Frame end time (sec) */
  double *x2;
  /** Prompts */
  double *prompts;
  /** Randoms */
  double *randoms;
  /** Trues = Prompts-randoms, but at least 1 */
  double *trues;
  /** Weights = (Frame duration)^2 / trues */
  double *weights;
} SIF;
/*****************************************************************************/
int SIF_TEST;
/*****************************************************************************/
void libsif_printdate(FILE *fp);
int sifRead(char *filename, SIF *data);
int sifWrite(SIF *data, char *filename);
void sifPrint(SIF *data);
void sifEmpty(SIF *data);
void sifWeight(SIF *data, double halflife);
void sifInit(SIF *data);
int sifSetmem(SIF *data, int frameNr);
/*****************************************************************************/
#define readSIF sifRead
#define writeSIF sifWrite
#define printSIF sifPrint
#define emptySIF sifEmpty
#define weightSIF sifWeight
#define initSIF sifInit
#define setmemSIF sifSetmem
/*****************************************************************************/
#endif

