/******************************************************************************

  libtpcimgiov.c  (c) 2005 Turku PET Centre

  This file contains function for printing the date and time when this library
  is compiled.
  
  Version:
  2004-11-07 Vesa Oikonen
  2005-01-20 Calle Laakkonen
  2005-04-26 Jarkko Johansson
  Functions libtpcimgio_print_readme(), libtpcimgio_print_history(),
  libtpcimgio_print_dreadme() and libtpcimgio_print_dhistory()
  are used for getting the Readme and History messages for the libtpcimgio,
  with and without Doxygen style tags. Remember to update the
  functions to get correct Readme and History messages!

  Function libtpcimgio_print_build(), is used for getting the build
  information.

  2005-08-01 1.1.1 CL/JJ
  Changed image loading/writing functions fname to const,
  and extern int VOL_TEST to int VOL_TEST.

  2005-10-10 1.1.2 CL
  See function libtpcimgio_print_history().

  2005-11-21 1.1.3 VO
  See halflife.c.

  2005-12-12 1.1.4 VO
  See imgfile.c.


******************************************************************************/
#include <stdio.h>
#include "libtpcimgiov.h"
/*****************************************************************************/
/** Library name. */
#define LIB_NAME "libtpcimgio"

/** Library version. */
#define LIB_VERSION "1.1.4"

/** Copyright. */
#define COPYRIGHT "(c) 2005 by Turku PET Centre"

/*****************************************************************************/
/** 
    Print the library readme to specified FILE pointer, use stdout for screen.
*/
void libtpcimgio_print_readme(FILE *fp){
  fputs(
	"\n"
	LIB_NAME" "LIB_VERSION" "COPYRIGHT"\n"
	"\n"
	"Build "__DATE__" "__TIME__"\n"
	"\n"
	"\n"
	"PET Image IO library\n"
	"-------------------------------------------------------------------------------\n"
	"\n"
	"2005-01-04\n"
	"Turku PET Centre\n"
	"\n"
	"Libtpcimgio is distributed under the GNU Lesser General Public Licence\n"
	"http://pet.utu.fi/staff/vesoik/programs/lgpl-license.html\n"
	"More information on open source licences: http://www.opensource.org\n"
	"\n"
	"Description\n"
	"-------------------------------------------------------------------------------\n"
	"\n"
	"The libtpcimgio library is a collection of commonly used C files in Turku PET Centre\n"
	"for image file input and output procedures. Libtpcimgio library supports analyze,\n"
	"ecat 6.x, ecat 7.x and partly interfile formats. \n"
	"\n"
	"List of files\n"
	"-------------------------------------------------------------------------------\n"
	"\n"
	"include/     - Includes all the header files for the .c files\n"
	"\n"
	"Makefile     - The makefile\n"
	"\n"
	"** .c files **\n"
	"\n"
	"analyze.c     - reading and writing Analyze 7.5 image files.\n"
	"\n"
	"ecat63ml.c    - Procedures for ECAT 6.3 matrix list.\n"
	"\n"
	"ecat63p.c     - Printing ECAT 6.3 headers.\n"
	"\n"
	"ecat63r.c     - Reading ECAT 6.3 files.\n"
	"\n"
	"ecat63w.c     - Writing ECAT 6.3 files.\n"
	"\n"
	"ecat7ml.c     - Procedures for ECAT 7.x matrix list.\n"
	"\n"
	"ecat7p.c      - Printing ECAT 7.x headers.\n"
	"\n"
	"ecat7r.c      - Reading ECAT 7.x files.\n"
	"\n"
	"ecat7w.c      - Writing ECAT 7.x files.\n"
	"\n"
	"img.c         - Procedures for 4D image data (common to all image file formats).\n"
	"\n"
	"imgfile.c     - Procedures for 4D image read/write.\n"
	"\n"
	"interfile.c   - Reading Interfile headers\n"
	"\n"
	"halflife.c    - Procedures for isotopes and correction of physical decay.\n"
	"\n"
	"vol.c         - Procedures for 3D image volume data (no time information).\n"
	"\n"
	"sif.c         - Routines for Scan Information Files (SIF).\n"
	"\n"
	"sifio.c       - Functions for reading and writing SIF format files.\n"
	"\n"
	"weight.c      - Functions for setting weight factors based on SIF.\n"
	"\n"
	"libtpcimgio.c - Program for printing Readme and History information, and for\n"
	"		 testing the library functions. \n"
	"\n"
	"libtpcimgiov.c- Version information for this library.\n"
	"\n"
	"\n"
	"Using the library\n"
	"-------------------------------------------------------------------------------\n"
	"\n"
	"The program that uses the library should include the .h file it needs.\n"
	"Example:\n"
	"    #include <img.h>\n"
	"\n"
	"libtpcimgio depends on libtpcmisc.\n"
	"Example:\n"
	"	gcc myprog.c -ltpcimgio -ltpcmisc\n"
	"\n",
	fp
	);

  fflush(fp);
}

/** 
    Print the library History to specified FILE pointer, 
    use stdout for screen.
*/
void libtpcimgio_print_history(FILE *fp)
{
  fputs(
	"2005-01-04 1.0.0 Vesa Oikonen, Calle Laakkonen, Riku Kln, Jarkko Johansson\n"
	"	Former libpet, the common PET C library, has been divided up in smaller\n"
	"	sublibraries that each handle a specific task. This library includes functions\n"
	"	utilised in image file input and output procedures. \n"
	"\n"
	"2005-03-03 1.0.0 Jarkko Johansson \n"
	"	imgproc.[c/h] moved to libtpcimgp library\n"
	"\n"
	"2005-04-05 1.0.1 (krs) Roman Krais\n"
	"        interfile.c added (for reading interfile headers)\n"
	"\n"
	"2005-04-25 1.1.0 Jarkko Johansson\n"
	"	History and Readme files included in new print functions:\n"
	"	libtpcimgio_print_readme(FILE *fp);\n"
	"	libtpcimgio_print_history(FILE *fp);\n"
	"	libtpcimgio_print_dreadme(FILE *fp);\n"
	"	libtpcimgio_print_dhistory(FILE *fp);\n"
	"	libtpcimgio_print_build(FILE *fp);\n"
	"	in file libtpcimgio.c. Update the the Readme and History\n"
	"	there.\n"
	"\n"
	"	Compiled in Windows with MinGW.\n"
	"\n"
	"2005-05-04 1.1.0 JJ\n"
	"       Minor changes in file sifio.c.\n"
	"\n"
	"2005-08-01 1.1.1 CL/JJ\n"
	"       Changed image loading/writing functions fname to const,\n"
	"       and extern int VOL_TEST to int VOL_TEST.\n"
	"\n"
	"2005-10-10 1.1.2 CL\n"
	"       imgWriteAnalyze() now writes only 1 frame at a time,\n"
	"       conserving memory.\n"
	"\n"
	"2005-11-21 1.1.3 VO\n"
	"       lambda2factor() now calculates correctly when removing\n"
	"       decay correction considering frame lengths.\n"
	"\n"
	"2005-12-12 1.1.4 VO\n"
	"       imgReadAnalyze() sets img.isotopeHalflife,\n"
	"       if isotope is found in SIF.\n"
	"\n",
	fp
	);
  fflush(fp);  
}

/** 
    Print the library Readme to specified FILE pointer with Doxygen tags, 
    use stdout for screen.
*/
void libtpcimgio_print_dreadme(FILE *fp)
{
  fprintf(fp,"/**\n\\mainpage %s %s %s\n\\section readme Readme\n<PRE>\n",LIB_NAME,LIB_VERSION,COPYRIGHT);
  libtpcimgio_print_readme(fp);
  fprintf(fp,"\n</PRE> \n */\n");
}

/** 
    Print the library History to specified FILE pointer with Doxygen tags, 
    use stdout for screen.
*/
void libtpcimgio_print_dhistory(FILE *fp)
{
  fprintf(fp,"/**\n\\page History\n\\section history History\n<PRE>\n");
  libtpcimgio_print_history(fp);
  fprintf(fp,"\n</PRE> \n */\n");
}

/** 
    Print the build info to specified FILE pointer, use stdout for screen.
*/
void libtpcimgio_print_build(FILE *fp)
{
  fprintf(fp,"\n %s %s %s\n",LIB_NAME,LIB_VERSION,COPYRIGHT);
  fprintf(fp,"\n Build %s %s\n",__DATE__,__TIME__);
}



/** Print the compilation date and time to specified FILE pointer  */
void libtpcimgio_printdate(FILE *fp)
{
  libtpcimgio_print_build(fp);
}

/*****************************************************************************/

/*****************************************************************************/

