/******************************************************************************
  Copyright (c) 2004,2005 by Turku PET Centre

  File: imgtransform.c
  
  Purpose: Additional procedures for processing 4D PET image data.
  Image transformation functions.

  Date: 2005-02-25

  Author: Vesa Oikonen, Riku Klen, Calle Laakkonen, Jarkko Johansson

  Version:
     2005-02-25: Calle Laakkonen, Jarkko Johansson

******************************************************************************/

/*****************************************************************************/
#include <string.h>
#include <stdlib.h>
#include <time.h>
/*****************************************************************************/
#include "imgtransform.h"
/*****************************************************************************/

/**
   Image scaling using the defined method.
*/
void imgScale(
	      /** Source image to be scaled */
	      IMG *src,
	      /** Scaled image; must be allocated to the size of resulting image */
	      IMG *targ,
	      /** Scaling factor */
	      float zoom,
	      /** Method code number */
	      int method)
{
  int frame, plane, x, y;
  float **tmp_targ;

// Allocate memory for temporary target matrix:
  tmp_targ = malloc(targ->dimy * sizeof(float*));
  for(y=0; y<targ->dimy; y++)
    tmp_targ[y] = malloc(targ->dimx * sizeof(float));

  for(plane=0; plane<src->dimz; plane++)
    for(frame=0; frame<src->dimt; frame++){
      integerScale(frame, src->m[plane], tmp_targ, src->dimx, src->dimy, zoom);
// Copy scaled image matrix to target image buffer:
      for(y=0; y<targ->dimy; y++)
	for(x=0; x<targ->dimx; x++)
	  targ->m[plane][y][x][frame] = tmp_targ[y][x];	
    }
}


/**
   Simple integer scaling function using pixel duplication.
*/
void integerScale(
		  /** Serial number of the frame to be scaled*/
		  int frame,
		  /** Source data in three dimensional array: srcp[y][x][frame] */
		  float ***src, 
		  /** Target data array: targ[y][x] */
		  float **targ, 
		  /** Width of the source data matrix */
		  int width,
		  /** Height of the source data matrix*/
		  int height,
		  /** Scaling factor */
		  int zoom)
{

  int w, h, z;

  for(h=0; h<height; h++){
    for(w=0; w<width; w++){
      float val;
      val=src[h][w][frame];
      for(z=0;z<zoom;z++) {
        targ[h*zoom][w*zoom + z]=val;
      }
    }
    for(z=1;z<zoom;z++) {
      memcpy(targ[h*zoom+z],targ[h*zoom],width*zoom*sizeof(float));
    }
  }

}

