/******************************************************************************
  Copyright (c)  2003,2004 by Turku PET Centre

  imgproc.h - definitions for imgproc.c

  Version:
  2003-07-01 Vesa Oikonen
  2003-07-07 VO
  2003-08-04 VO
    Included new scanner types.
  2003-09-30 VO
  2003-10-04 VO
  2003-10-13 VO
  2003-12-03 VO
  2003-12-14 VO
    Scanner type definitions moved into img.h.
  2003-12-18 VO
  2004-07-18 VO
  2004-07-20 VO
  2005-22-02 Jarkko Johansson
    Moved from libpet to libtpcimgp.
    Function name constants defined.

******************************************************************************/
#ifndef _IMGPROC_H
#define _IMGPROC_H
/*****************************************************************************/
#include <img.h>
/*****************************************************************************/
extern int imgArithm(IMG *img1, IMG *img2, char operation, float ulimit);
extern int imgArithmConst(IMG *img, float operand, char operation, float ulimit);
extern int imgArithmFrame(IMG *img1, IMG *img2, char operation, float ulimit);
extern int imgThresholdTemplate(IMG *img, float minValue, float maxValue, IMG *timg);
extern int imgThresholdByTemplate(IMG *img, IMG *templt, float thrValue);
extern int imgAverageTAC(IMG *img, float *tac);
extern int imgAverageTemplateTAC(IMG *img, IMG *timg, float *tac);
extern int imgAverageAUC(IMG *img, float *avgauc);
extern int imgLog10(IMG *img);
extern int imgMax(IMG *img, float *maxvalue);
extern int imgAbsMax(IMG *img, float *maxvalue);
extern int imgMinMax(IMG *img, float *minvalue, float *maxvalue);
extern int imgFrameMinMax(IMG *img, int frame, float *minvalue, float *maxvalue);
extern int imgFrameIntegral(IMG *img, int first, int last, IMG *iimg);
extern int imgRawCountsPerTime(IMG *img, int operation);
extern void imgFlipHorizontal(IMG *img);
extern void imgFlipVertical(IMG *img);
extern void imgFlipPlanes(IMG *img);
extern int imgSetScanner(IMG *img, int scanner_type);

/*****************************************************************************/

/*****************************************************************************/
#endif /* _IMGPROC_H */

