/******************************************************************************
  Copyright (c)  2003,2004 by Turku PET Centre

  imgtransform.h - definitions for imgtransform.c

  Version:
    2005-02-25: Calle Laakkonen, Jarkko Johansson

******************************************************************************/
#ifndef _IMGTRANSFORM_H
#define _IMGTRANSFORM_H
/*****************************************************************************/
#include <img.h>
/*****************************************************************************/
extern void imgScale(
	      /** Source image to be scaled */
	      IMG *src,
	      /** Scaled image; must be allocated to the size of resulting image */
	      IMG *targ,
	      /** Scaling factor */
	      float zoom,
	      /** Method code number */
	      int method);

extern void integerScale(
		  /** Serial number of the frame to be scaled*/
		  int frame,
		  /** Source data in three dimensional array: srcp[y][x][frame] */
		  float ***src, 
		  /** Target data array: targ[y][x] */
		  float **targ, 
		  /** Width of the source data matrix */
		  int width,
		  /** Height of the source data matrix*/
		  int height,
		  /** Scaling factor */
		  int zoom);

#endif
