/**
  Copyright (c) 2004,2005 by Turku PET Centre

  File: libtpcimgpv.c  

  Purpose: functions for printing the information on the library. 
  
  Version:

  2005-02-22 1.0.0 Jarkko Johansson

  2005-04-26 1.1.0 JJ
  Functions libtpcimgp_print_readme(), libtpcimgp_print_history(),
  libtpcimgp_print_dreadme() and libtpcimgp_print_dhistory()
  are used for getting the Readme and History messages for the libtpcimgp,
  with and without Doxygen style tags. Remember to update the
  functions to get correct Readme and History messages!

  Function libtpcimgp_print_build(), is used for getting the build
  information.
 
  2005-06-09 1.2.0 Kaisa sederholm
  files median.c, lms.c, lts.c ans mestim.c removed and added to
  libtpcmodel library

*/
/*****************************************************************************/

/** Library name. */
#define LIB_NAME "libtpcimgp"

/** Library version. */
#define LIB_VERSION "1.2.0"

/** Copyright. */
#define COPYRIGHT "(c) 2005 by Turku PET Centre"

/*****************************************************************************/

#include <stdio.h>
#include "libtpcimgpv.h"

/*****************************************************************************/

/** 
    Print the library readme to specified FILE pointer, use stdout for screen.
*/
void libtpcimgp_print_readme(FILE *fp){

  fputs(
       "\n"
       LIB_NAME" "LIB_VERSION" "COPYRIGHT"\n"
       "\n"
       "Build "__DATE__" "__TIME__"\n"
       "\n"
       "\n"
       "PET Image Processing library   \n"
       "-------------------------------------------------------------------------------\n"
       "\n"
       "Libtpcimgp is distributed under the GNU Lesser General Public Licence\n"
       "http://pet.utu.fi/staff/vesoik/programs/lgpl-license.html\n"
       "More information on open source licences: http://www.opensource.org\n"
       "\n"
       "Description\n"
       "-------------------------------------------------------------------------------\n"
       "\n"
       "The libtpcimgp library is a collection of commonly used C files\n"
       "at Turku PET Centre for image processing.\n"
       "\n"
       "List of files\n"
       "-------------------------------------------------------------------------------\n"
       "\n"
       "Doxyfile        - Doxygen configuration file.\n"
       "\n"
       "include/        - Includes all the header files for the .c files\n"
       "\n"
       "Makefile    	- The makefile\n"
       "\n"
       "** .c files **\n"
       "\n"
       "imgproc.c       - Functions for image processing.\n"
       "\n"
       "imgtransform.c	- Functions for image transformations.\n"
       "\n"
       "libtpcimgp.c	- Functions for running tests on libtpcimgp.\n"
       "\n"
       "libtpcimgpv.c	- Functions for printing information on this library.\n"
       "\n"
       "point.c		- Functions for processing with points.\n"
       "\n"
       "\n"
       "\n"
       "Using the library\n"
       "-------------------------------------------------------------------------------\n"
       "\n"
       "The program that uses the library should include the .h file it needs.\n"
       "Example:\n"
       "    #include <imgproc.h>  // includes functions for processing\n"
       "    #include <imgtransform.h>   // includes functions for transforms \n"
       "    #include <point.h>  // includes the 3D point structure\n"
       "    #include <libtpcimgpv.h>  // includes the information\n"
       "\n"
       "libtpcimgp depends on libtpcimgio and libtpcmisc.\n"
       "Example:\n"
       "	gcc myprog.c -ltpcimgio -ltpcmisc -ltpcimgp \n"
       "\n",
       fp
       );

  fflush(fp);
}

/** 
    Print the library History to specified FILE pointer, 
    use stdout for screen.
*/
void libtpcimgp_print_history(FILE *fp)
{
  fputs(
	" \n"
	"2005-01-04 version 1.0.0 Vesa Oikonen, Calle Laakkonen, Riku Kln, Jarkko Johansson \n"
	"  Former libpet, the c	@ cd .. ommon PET C library, has been divided up in smaller	\n"
	"  sublibraries that each handle a specific task. This library includes functions \n"
	"  utilised in image processing.\n"
	"\n"
	"2005-04-21 1.0.1 JJ\n"
	"  Changes in files libtpcimgpv.c and .h:\n"
	"\n"
	"  Functions libtpcimgp_print_readme(), libtpcimgp_print_history(),\n"
	"  libtpcimgp_print_dreadme() and libtpcimgp_print_dhistory()\n"
	"  are used for getting the Readme and History messages for the libtpcimgp,\n"
	"  with and without Doxygen style tags. Remember to update the\n"
	"  functions to get correct Readme and History messages!\n"
	"\n"
	"  Function libtpcimgp_print_build(), is used for getting the build\n"
	"  information.\n"
	"\n"
	"2005-04-26 1.1.0 JJ\n"
	"  Compiled with MinGW.\n"
	"  Changes made in class point:\n"
	"  round() -> pRound() (conflict with math.h round())\n"
	"  PI = value -> #ifndef PI = value #endif\n"
	"\n"
	"2005-06-02 1.1.1 Kaisa Sederholm\n"
	"  mestim.c added \n"
        "\n"
        "2005-06-09 1.2.0 KS"
        "files median.c, lms.c, lts.c ans mestim.c removed and added to"
        "libtpcmodel library"
	"\n",
	fp
	);

  fflush(fp);
}

/** 
    Print the library Readme to specified FILE pointer with Doxygen tags, 
    use stdout for screen.
*/
void libtpcimgp_print_dreadme(FILE *fp)
{
  fprintf(fp,"/**\n\\mainpage %s %s %s\n\\section readme Readme\n<PRE>\n",LIB_NAME,LIB_VERSION,COPYRIGHT);
  libtpcimgp_print_readme(fp);
  fprintf(fp,"\n</PRE> \n */\n");
}

/** 
    Print the library History to specified FILE pointer with Doxygen tags, 
    use stdout for screen.
*/
void libtpcimgp_print_dhistory(FILE *fp)
{
  fprintf(fp,"/**\n\\page History\n\\section history History\n<PRE>\n");
  libtpcimgp_print_history(fp);
  fprintf(fp,"\n</PRE> \n */\n");
}

/** 
    Print the build info to specified FILE pointer, use stdout for screen.
*/
void libtpcimgp_print_build(FILE *fp)
{
  fprintf(fp,"\n %s %s %s\n",LIB_NAME,LIB_VERSION,COPYRIGHT);
  fprintf(fp,"\n Build %s %s\n",__DATE__,__TIME__);
}




/*****************************************************************************/

