/******************************************************************************
  Copyright (c) 2006 Turku PET Centre

  File:        decpoint.c
  Description: Contains functions for reading real numbers from strings which
               may contain either decimal dots or commas.

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 2.1 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
  See the GNU Lesser General Public License for more details:
  http://www.gnu.org/copyleft/lesser.html

  You should have received a copy of the GNU Lesser General Public License
  along with this library/program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA

  Turku PET Centre, Turku, Finland, http://www.turkupetcentre.fi

  Modification history:
  2006-06-03 Vesa Oikonen
    First created.

******************************************************************************/
#include <stdio.h>
#include <stdlib.h>
#include <ctype.h>
#include <string.h>
#include <math.h>
/*****************************************************************************/
#include "include/decpoint.h"
/*****************************************************************************/

/*****************************************************************************/
/** Checks whether argument string contains a decimal comma instead of dot.
\return Returns 1 if decimal comma is found and 0 if not found.
 */
int dec_comma_is(char *str)
{
  char *cptr=str;
  if(strchr(str, '.')!=NULL) return(0);
  while(cptr!=NULL) {if(*cptr==',') return(1); cptr++;}
  return(atof(str));
}
/*****************************************************************************/

/*****************************************************************************/
/** Replacement of atof(), which works whether string contains decimal dots
 *  or decimal commas. Possible commas are replaced by dots in the
 *  argument string.
 */
double atof_dpi(char *str)
{
  char *cptr;

  /* If string contains a dot, then use atof directly */
  if(strchr(str, '.')!=NULL) return(atof(str));
  /* Otherwise, convert all commas to dots */
  while((cptr=strchr(str, ','))!=NULL) *cptr='.';
  return(atof(str));
}
/*****************************************************************************/

/*****************************************************************************/
