/******************************************************************************

  Copyright (c) 2004,2005 by Turku PET Centre

  ift.h

  Modification history:
  2004-08-15 VO
  2004-10-14 VO
    iftFindNthValue() function name corrected.
  2004-10-15 VO
    Included iftFindNthKey().
  2004-11-23 VO
    Included iftReplaceNthValue().
  2005-01-05 VO
    ift_status moved in here.


******************************************************************************/
#ifndef _IFT_H
#define _IFT_H
/*****************************************************************************/

/*****************************************************************************/
typedef struct {
  /** Key (comment) type character: space, #, ; */
  char type;
  /** Undefined short integer for the use of programmer */
  short int sw;
  /** Pointer to the NULL terminated key string; NULL if not allocated */
  char *key;
  /** Pointer to the NULL terminated key value string; NULL if not allocated */
  char *value;
} IFT_KEY_AND_VALUE;
typedef struct {
  /** Number of allocated places for keys and values */
  int _memNr;
  /** Number of stored keys and their values */
  int keyNr;
  /** Type of the parameter file:
      0=unknown, 1=interfile ':=' , 2=setup '=', 3=result ':' */
  int type;
  /** Pointer to a status message */
  char *status;
  /** List of key-value -pairs */
  IFT_KEY_AND_VALUE *item;
  /** Size of binary data (in bytes); not yet supported */
  size_t datasize;
  /** Pointer to binary data; not yet supported */
  unsigned char *data;
} IFT;
/*****************************************************************************/
int IFT_TEST;
/*****************************************************************************/
void libift_printdate(FILE *fp);
void iftSetStatus(IFT *ift, int status);
void iftInit(IFT *ift);
void iftEmpty(IFT *ift);
int iftPut(IFT *ift, char *key, char *value, char *cmt_type);
int iftRead(IFT *ift, char *filename, int is_key_required);
int iftWriteItem(IFT *ift, int item, FILE *fp);
int iftWrite(IFT *ift, char *filename);
int iftGet(IFT *ift, char *key);
int iftGetNth(IFT *ift, char *key, int n);
int iftFindNthKey(IFT *ift, char *str, int n);
int iftFindNthValue(IFT *ift, char *str, int n);
int iftDeleteItem(IFT *ift, int item);
int iftReplaceNthValue(IFT *ift, int item, char *value);
/*****************************************************************************/
#endif

