/******************************************************************************

  libtpcmiscv.c  (c) 2005,2006 Turku PET Centre

  This file contains function for printing the date and time when this library
  is compiled.

  Version:
  2004-11-07 Vesa Oikonen
  2005-01-20 Calle Laakkonen
  2005-04-26 1.1.0 Jarkko Johansson
  Functions libtpcmisc_print_readme(), libtpcmisc_print_history(),
  libtpcmisc_print_dreadme() and libtpcmisc_print_dhistory()
  are used for getting the Readme and History messages for the libtpcmisc,
  with and without Doxygen style tags. Remember to update the
  functions to get correct Readme and History messages!
  2006-03-26 1.1.1 VO
  Bug correction in iftfile.c.
  2006-06-03 1.1.2 VO
  Added decpoint.c and decpoint.h.


  Function libtpcmisc_print_build(), is used for getting the build
  information.

*/

/*****************************************************************************/

/** Library name. */
#define LIB_NAME "libtpcmisc"

/** Library version. */
#define LIB_VERSION "1.1.2"

/** Copyright. */
#define COPYRIGHT "(c) 2005,2006 by Turku PET Centre"

/*****************************************************************************/

#include <stdio.h>
#include "libtpcmiscv.h"

/*****************************************************************************/

/**
    Print the library readme to specified FILE pointer, use stdout for screen.
*/
void libtpcmisc_print_readme(FILE *fp){

  fputs(
       "\n"
       LIB_NAME" "LIB_VERSION" "COPYRIGHT"\n"
       "\n"
       "Build "__DATE__" "__TIME__"\n"
       "\n"
       "\n"
       "PET Miscallaneous library\n"
       "-------------------------------------------------------------------------------\n"
       "\n"
       "Contents\n"
       "-------------------------------------------------------------------------------\n"
       "\n"
       "include/     - Includes all the header files for the .c files\n"
       "\n"
       "Makefile     - The makefile\n"
       "\n"
       "README       - This file.\n"
       "\n"
       "** .c files **\n"
       "\n"
       "decpoint.c   -  Reading floating point value from string with decimal comma.\n"
       "\n"
       "idcrypt.c    -  String encryption/decryption.\n"
       "\n"
       "intex.c      -  Expanding string expressions of integers to an array of ints.\n"
       "\n"
       "ift.c        -  Functions for basic processing of IFT data structure.\n"
       "\n"
       "iftfile.c    -  Functions for basic processing of IFT data structure.\n"
       "\n"
       "iftsrch.c    -  Search functions for IFT contents.\n"
       "\n"
       "libtpcmisc.c - 	Program for printing the Readme, History and build information, \n"
       "		and for testing the library functions.\n"
       "\n"
       "libtpcmiscv.c- 	Information for this library.\n"
       "\n"
       "petc99.c     -  ISO C99 functions that are not yet widely available in\n"
       "                common compilers.\n"
       "\n"
       "studynr.c    -  Functions for processing PET study number.\n"
       "\n"
       "swap.c       -  Byte swapping between little and big endian platforms.\n"
       "\n"
       "Using the library\n"
       "-------------------------------------------------------------------------------\n"
       "\n"
       "The program that uses the library should include the .h file it needs.\n"
       "Example:\n"
       "    #include <intex.h>\n"
       "\n"
       "    gcc myprog.c -ltpcmisc\n"
       "\n"
       "\n",
       fp
       );

  fflush(fp);
}

/**
    Print the library History to specified FILE pointer,
    use stdout for screen.
*/
void libtpcmisc_print_history(FILE *fp)
{
  fputs(
	"\n"
	"2005-01-04 version 1.0.0 Vesa Oikonen, Calle Laakkonen, Riku Kln, Jarkko Johansson \n"
	"  Former libpet, the common PET C library, has been divided up in smaller	\n"
	"  sublibraries that each handle a specific task. This library includes miscellaneous \n"
	"  functions utilised in PET data processing.\n"
	"\n"
	"2005-04-21 1.0.1 JJ\n"
	"  Changes in files libtpcmiscv.c and .h:\n"
	"\n"
	"  Functions libtpcmisc_print_readme(), libtpcmisc_print_history(),\n"
	"  libtpcmisc_print_dreadme() and libtpcmisc_print_dhistory()\n"
	"  are used for getting the Readme and History messages for the libtpcmisc,\n"
	"  with and without Doxygen style tags. Remember to update the\n"
	"  functions to get correct Readme and History messages!\n"
	"\n"
	"  Function libtpcmisc_print_build(), is used for getting the build\n"
	"  information.\n"
	"\n"
	"2005-04-26 1.1.0 JJ\n"
	"  Compiled with MinGW.\n"
        "  Merged with libift.\n"
	"\n"
	"2006-03-16 1.1.1 VO\n"
	"  Correction in iftread().\n"
	"\n"
	"2006-06-03 1.1.2 VO\n"
	"  Added decpoint.c and decpoint.h.\n"
	"\n",
	fp
	);

  fflush(fp);
}

/**
    Print the library Readme to specified FILE pointer with Doxygen tags,
    use stdout for screen.
*/
void libtpcmisc_print_dreadme(FILE *fp)
{
  fprintf(fp,"/**\n\\mainpage %s %s %s\n\\section readme Readme\n<PRE>\n",LIB_NAME,LIB_VERSION,COPYRIGHT);
  libtpcmisc_print_readme(fp);
  fprintf(fp,"\n</PRE> \n */\n");
}

/**
    Print the library History to specified FILE pointer with Doxygen tags,
    use stdout for screen.
*/
void libtpcmisc_print_dhistory(FILE *fp)
{
  fprintf(fp,"/**\n\\page History\n\\section history History\n<PRE>\n");
  libtpcmisc_print_history(fp);
  fprintf(fp,"\n</PRE> \n */\n");
}

/**
    Print the build info to specified FILE pointer, use stdout for screen.
*/
void libtpcmisc_print_build(FILE *fp)
{
  fprintf(fp,"\n %s %s %s\n",LIB_NAME,LIB_VERSION,COPYRIGHT);
  fprintf(fp,"\n Build %s %s\n",__DATE__,__TIME__);
}

/*****************************************************************************/


/** Print the compilation date and time to specified FILE pointer  */
void libtpcmisc_printdate(FILE *fp)
{
  libtpcmisc_print_build(fp);
}
/*****************************************************************************/

/*****************************************************************************/

