/*****************************************************************************

  Copyright (c) 1996-2002 by Turku PET Centre

  gaussdev.c

  Description:  Returns a normally distributed (Gaussian) deviate with
                zero mean and unit variance.


 *****************************************************************************

  Version:
  1996-01-30 Vesa Oikonen
  1998-04-21 VO
    Version with fixed seed for random numbers.
  2000-08-03 VO
    Same code for DOS and UNIX.
  2001-04-12 VO
    Generation of seed is moved to its own function which can be called from
    outside also.
  2002-09-14 VO
    Added the reference to Box-Mller transformation.
    Seed is specified as variable long int GAUSSDEV_SEED;
    it can thus be changed in the main program before calling gaussdev().


******************************************************************************/
#include <stdio.h>
#include <math.h>
#include <stdlib.h>
/*****************************************************************************/
#include "include/gaussdev.h"
/*****************************************************************************/
#ifndef RAND_MAX
#define RAND_MAX 32767
#endif
/*****************************************************************************
 *
 *  Applies the polar form of Box-Mller transform to produce pseudo-random
 *  numbers with Gaussian (normal) distribution which has a zero mean and
 *  standard deviation of one.
 *  Box GEP, Muller ME. A note on the generation of random normal deviates.
 *  Annals of Mathematical Statistics, Volume 29, Issue 2, 1958, 610-611.
 *  Available from JSTOR http://www.jstor.org/
 *
 *****************************************************************************/
double gaussdev()
{
  static int ready=0, first=1;
  static double dev;
  double fac, rsq, a, b;
  if(first) {first=0; init_gaussdev();}

  /* If we don't have deviate already, then we'll have to make one */
  if(!ready) {
    do {
      a = 2.*(double)rand()/(double)RAND_MAX - 1.0; 
      b = 2.*(double)rand()/(double)RAND_MAX - 1.0; 
      rsq = a*a + b*b; 
    } while (rsq>=1.0 || rsq==0.0);
   
    fac = sqrt(-2.0*log(rsq)/rsq);
    dev=a*fac; ready=1; 
    return(b*fac); 
  } else { /* dev is ready so return it */
    ready=0;
    return(dev);
  }
}
/*****************************************************************************/

/*****************************************************************************/
void init_gaussdev()
{
  if(GAUSSDEV_SEED<1L) GAUSSDEV_SEED=893165470L;
  srand(GAUSSDEV_SEED);
}
/*****************************************************************************/

