/******************************************************************************
  Copyright (c) 2000-2004 by Turku PET Centre

  integr.h

  Version:
  2001-03-31
  2002-02-12
  2004-01-20

******************************************************************************/
#ifndef _INTEGR_H
#define _INTEGR_H
/*****************************************************************************/
int INTEGR_TEST;
/*****************************************************************************/
int interpolate(
    double *x, double *y, int nr,
    double *newx, double *newy, double *newyi, double *newyii, int newnr
  );
int finterpolate(
    float *x, float *y, int nr,
    float *newx, float *newy, float *newyi, float *newyii, int newnr
  );

#if(0)
int interpolate2pet(
    double *x, double *y, int nr,
    double *newx1, double *newx2, 
    double *newy, double *newyi, double *newyii, int newnr
  );
#endif

int integrate(
    double *x, double *y, int nr,
    double *yi
  );
int fintegrate(
    float *x, float *y, int nr,
    float *yi
  );

int petintegrate(
    double *x1, double *x2, double *y, int nr, 
    double *newyi, double *newyii
  );
int fpetintegrate(
    float *x1, float *x2, float *y, int nr, 
    float *newyi, float *newyii
  );
    
int interpolate4pet(
    double *x, double *y, int nr,
    double *newx1, double *newx2, 
    double *newy, double *newyi, double *newyii, int newnr
  );
int finterpolate4pet(
    float *x, float *y, int nr,
    float *newx1, float *newx2, 
    float *newy, float *newyi, float *newyii, int newnr
  );

int petintegral(
    double *x1, double *x2, double *y, int nr,   
    double *ie, double *iie
  );
int fpetintegral(
    float *x1, float *x2, float *y, int nr,   
    float *ie, float *iie
  );

int petintegrate2fe(
    double *x1, double *x2, double *y, int nr,    
    double *e, double *ie, double *iie
  );
int fpetintegrate2fe(
    float *x1, float *x2, float *y, int nr,    
    float *e, float *ie, float *iie
  );
/*****************************************************************************/
#endif
