/******************************************************************************
  Copyright (c) 2001-2004 by Turku PET Centre

  simulate.h

  Version:
    2001-07-28 VO
    2002-03-13 VO
    2003-03-04 VO

******************************************************************************/
#ifndef _SIMULATE_H
#define _SIMULATE_H
/*****************************************************************************/
int SIMULATE_TEST;
/*****************************************************************************/
int c3sSIM(
    double *t, double *ca, int nr, double k1, double k2,
    double k3, double k4, double k5, double k6,
    double *ct, double *cta, double *ctb, double *ctc
  );

int c3pSIM(
    double *t, double *ca, int nr, double k1, double k2,
    double k3, double k4, double k5, double k6,
    double *ct, double *cta, double *ctb, double *ctc
  );

int c3vsSIM(
    double *t, double *ca, double *cb, int nr,
    double k1, double k2, double k3, double k4, double k5, double k6,
    double f, double vb, double fa,
    double *cpet, double *cta, double *ctb, double *ctc,
    double *ctab, double *ctvb
  );

int c3vpSIM(
    double *t, double *ca, double *cb, int nr,
    double k1, double k2, double k3, double k4, double k5, double k6,
    double f, double vb, double fa,
    double *cpet, double *cta, double *ctb, double *ctc,
    double *ctab, double *ctvb
  );

int autointerpolateDFT(
    DFT *dft, DFT *dft2, double endtime
  );

int c2lSIM(
    double *t, double *ca, int nr, double k1, double k2,
    double k3, double kLoss, double *ct, double *cta, double *ctb
  );

int c2vlSIM(
    double *t, double *ca, double *cb, int nr,
    double k1, double k2, double k3, double kL,
    double f, double vb, double fa,
    double *cpet, double *cta, double *ctb,
    double *ctab, double *ctvb
  );

int rtcmSIM(
    double *t, double *cr, int nr, double R1, double k2,
    double k3, double k4, double *ct, double *cta, double *ctb
  );

int srtmSIM(
    double *t, double *cr, int nr, double R1, double k2,
    double BP, double *ct
  );

int trtmSIM(
    double *t, double *cr, int nr, double R1, double k2,
    double k3, double *ct
  );

int simHuangmet(
    double *t, double *ctot, int nr,
    double k01, double k12, double k21, double k03, double k34, double k43,
    double *c0, double *c1, double *c3 
  );
/*****************************************************************************/
#endif
