/******************************************************************************

  libtpcmodelv.c  (c) 2005 Turku PET Centre

  This file contains function for printing the date and time when this library
  is compiled.
  
  Version:
  2004-11-07 Vesa Oikonen
  2005-01-20 Calle Laakkonen
  2005-04-27 Jarkko Johansson
  2005-06-09 1.2.0 Kaisa Sederholm
    Robust estimation functions removed from libtpcimgp and added 
    to this library. (median.c, lms.c, lts.c and mestim.c)
  2005-12-27 1.2.1 Vesa Oikonen
    See tgo.c.

******************************************************************************/
/** Library name. */
#define LIB_NAME "libtpcmodel"

/** Library version. */
#define LIB_VERSION "1.2.1"

/** Copyright. */
#define COPYRIGHT "(c) 2005 by Turku PET Centre"

/*****************************************************************************/

#include <stdio.h>
#include "libtpcmodelv.h"

/*****************************************************************************/

/** 
    Print the library readme to specified FILE pointer, use stdout for screen.
*/
void libtpcmodel_print_readme(FILE *fp){

  fputs(
       "\n"
       LIB_NAME" "LIB_VERSION" "COPYRIGHT"\n"
       "\n"
       "Build "__DATE__" "__TIME__"\n"
       "\n"
       "\n"
       "PET Modeling library\n"
       "-------------------------------------------------------------------------------\n"
       "\n"
       "Contents\n"
       "-------------------------------------------------------------------------------\n"
       "\n"
       "include/     - Includes all the header files for the .c files\n"
       "\n"
       "Makefile     - The makefile\n"
       "\n"
       "** .c files **\n"
       "\n"
       "aic.c          -  Model selection and weighting using Akaike's information criteria.\n"
       "\n"
       "bootstrap.c    -  Bootstrap algorithm for computing parameter confidence limits and\n"
       "                standard deviations.\n"
       "\n"
       "gaussdev.c     -  Adds normally distributed Gaussian deviate with zero mean and unit variance.\n"
       "\n"
       "hholder.c      -  Householder transform.\n"
       "\n"
       "integr.c       -  TAC interpolation and integration.\n"
       "\n"
       "llsqwt.c       -  Methods for line fit with errors in both coordinates.\n"
       "\n"
       "nnls.c         -  Nonnegative linear least squares (Lawson-Hanson algorithm).\n"
       "\n"
       "pearson.c      -  Calculation of Pearson's correlation coefficient.\n"
       "\n"
       "powell.c       -  Powell-Brent minimization routine.\n"
       "\n"
       "qr.c           -  QR decomposition for overdetermined systems.\n"
       "\n"
       "simplex.c      -  Simplex (Nelder-Mead) minimization routine.\n"
       "\n"
       "simulate.c     -  Simulation of compartmental model curves.\n"
       "\n"
       "tgo.c          -  Topographical global optimization, based on algorithm by Trn & Viitanen.\n"
       "\n"
       "lms.c		- Routines for calculating least median of\n"
       "                  squares estimate for single data\n"
       "\n"
       "lts.c		- Least trimmed squares estimates for univariate location and variance\n"
       "\n"
       "median.c	- Functions related to calculation of median value.\n"
       "\n"
       "\n"
       "mestim.c	- Functions related to calculation of M-estimator. \n"
       "                  At the moment contains Huber's function, but other M-estimators\n"
       "                  can be added.\n"
       "\n" 
       "libtpcmodel.c  - Program for printing the Readme, History and build information,\n"
       "                 and for testing the library functions.\n"
       "\n"
       "libtpcmodelv.c -  Information for this library.\n" 
       "\n"
       "\n"
       "Using the library\n"
       "-------------------------------------------------------------------------------\n"
       "\n"
       "The program that uses the library should include the .h file it needs.\n"
       "Example:\n"
       "    #include <aic.h>\n"
       "\n"
       "libtpcmodel depends on libtpcmisc.\n"
       "Example:\n"
       "	gcc myprog.c -ltpcmodel -ltpcmisc\n"
       "\n"
       "\n",
       fp
       );

  fflush(fp);
}

/** 
    Print the library History to specified FILE pointer, 
    use stdout for screen.
*/
void libtpcmodel_print_history(FILE *fp)
{
  fputs(
	"\n"
	"2005-01-04 version 1.0.0 Vesa Oikonen, Calle Laakkonen, Riku Kln, Jarkko Johansson \n"
	"  Former libpet, the common PET C library, has been divided up in smaller	\n"
	"  sublibraries that each handle a specific task. This library includes modelling \n"
	"  functions utilised in PET data processing.\n"
	"\n"
	"2005-04-27 1.1.0 JJ\n"
	"  Changes in files libtpcmodelv.c and .h:\n"
	"\n"
	"  Functions libtpcmodel_print_readme(), libtpcmodel_print_history(),\n"
	"  libtpcmodel_print_dreadme() and libtpcmodel_print_dhistory()\n"
	"  are used for getting the Readme and History messages for the libtpcmodel,\n"
	"  with and without Doxygen style tags. Remember to update the\n"
	"  functions to get correct Readme and History messages!\n"
	"\n"
	"  Function libtpcmodel_print_build(), is used for getting the build\n"
	"  information.\n"
	"\n"
	"  Compiled with MinGW.\n"
	"\n"
        "2005-06-09 1.1.0 Kaisa Sederholm\n"
        "  Robust estimation functions removed from libtpcimgp\n"
        "  and added to this library.\n"
        " (median.c, lms.c, lts.c and mestim.c)\n"
	"\n"
        "2005-12-27 1.2.1 Kaisa Sederholm\n"
        "  Point distances in topographical minimization are normalized for\n"
        "  parameter magnitudes.\n"
	"\n",
	fp
	);

  fflush(fp);
}

/** 
    Print the library Readme to specified FILE pointer with Doxygen tags, 
    use stdout for screen.
*/
void libtpcmodel_print_dreadme(FILE *fp)
{
  fprintf(fp,"/**\n\\mainpage %s %s %s\n\\section readme Readme\n<PRE>\n",LIB_NAME,LIB_VERSION,COPYRIGHT);
  libtpcmodel_print_readme(fp);
  fprintf(fp,"\n</PRE> \n */\n");
}

/** 
    Print the library History to specified FILE pointer with Doxygen tags, 
    use stdout for screen.
*/
void libtpcmodel_print_dhistory(FILE *fp)
{
  fprintf(fp,"/**\n\\page History\n\\section history History\n<PRE>\n");
  libtpcmodel_print_history(fp);
  fprintf(fp,"\n</PRE> \n */\n");
}

/** 
    Print the build info to specified FILE pointer, use stdout for screen.
*/
void libtpcmodel_print_build(FILE *fp)
{
  fprintf(fp,"\n %s %s %s\n",LIB_NAME,LIB_VERSION,COPYRIGHT);
  fprintf(fp,"\n Build %s %s\n",__DATE__,__TIME__);
}

/*****************************************************************************/


/** Print the compilation date and time to specified FILE pointer  */
void libtpcmodel_printdate(FILE *fp)
{
  libtpcmodel_print_build(fp);
}
/*****************************************************************************/

