/******************************************************************************

  libtpcroiv.c  (c) 2005 Turku PET Centre

  This file contains function for printing the date and time when this library
  is compiled.
  
  Version:
  2004-11-07 Vesa Oikonen

  2005-01-20 Calle Laakkonen

  2005-04-26 Jarkko Johansson
  Functions libtpcroi_print_readme(), libtpcroi_print_history(),
  libtpcroi_print_dreadme() and libtpcroi_print_dhistory()
  are used for getting the Readme and History messages for the libtpcroi,
  with and without Doxygen style tags. Remember to update the
  functions to get correct Readme and History messages!

  Function libtpcroi_print_build(), is used for getting the build
  information.


******************************************************************************/

/** Library name. */
#define LIB_NAME "libtpcroi"

/** Library version. */
#define LIB_VERSION "1.1.0"

/** Copyright. */
#define COPYRIGHT "(c) 2005 by Turku PET Centre"

/*****************************************************************************/

#include <stdio.h>
#include "libtpcroiv.h"

/*****************************************************************************/
/** 
    Print the library readme to specified FILE pointer, use stdout for screen.
*/
void libtpcroi_print_readme(FILE *fp){
  fputs(
	"\n"
	LIB_NAME" "LIB_VERSION" "COPYRIGHT"\n"
	"\n"
	"Build "__DATE__" "__TIME__"\n"
	"\n"
	"\n"
	"PET ROI library\n"
	"\n"
	"Contents\n"
	"-------------------------------------------------------------------------------\n"
	"\n"
	"include/     - Includes all the header files for the .c files\n"
	"\n"
	"Makefile     - The makefile\n"
	"\n"
	"** .c files **\n"
	"\n"
	"roi.c        - Reading and writing CTI ECAT 6.3 region-of-interest files.\n"
	"\n"
	"oldroi.c     -	Old ROI API.\n"
	"\n"
	"libtpcroiv.c - Functions for printing the library information.\n"
	"\n"
	"libtpcroi.c  - Program for printing the library information,\n"
	"               and for testing the library functions.\n"
	"\n"
	"Using the library\n"
	"-------------------------------------------------------------------------------\n"
	"\n"
	"The program that uses the library should include the .h file it needs.\n"
	"Example:\n"
	"    #include <roi.h>\n"
	"\n"
	"libtpcroi depends on libtpcmisc.\n"
	"Example:\n"
	"\n"
	"	gcc myprog.c -ltpcroi -ltpcmisc\n"
	"\n"
	"\n",
	fp
	);

  fflush(fp);
}

/** 
    Print the library History to specified FILE pointer, 
    use stdout for screen.
*/
void libtpcroi_print_history(FILE *fp)
{
  fputs(
	"\n"
	"  2005-04-26 Jarkko Johansson\n"
	"  Functions libtpcroi_print_readme(), libtpcroi_print_history(),\n"
	"  libtpcroi_print_dreadme() and libtpcroi_print_dhistory()\n"
	"  are used for getting the Readme and History messages for the libtpcroi,\n"
	"  with and without Doxygen style tags. Remember to update the\n"
	"  functions to get correct Readme and History messages!\n"
	"\n"
	"  Function libtpcroi_print_build(), is used for getting the build\n"
	"  information.\n"
	"\n"
	"\n",
	fp
	);
  fflush(fp);  
}

/** 
    Print the library Readme to specified FILE pointer with Doxygen tags, 
    use stdout for screen.
*/
void libtpcroi_print_dreadme(FILE *fp)
{
  fprintf(fp,"/**\n\\mainpage %s %s %s\n\\section readme Readme\n<PRE>\n",LIB_NAME,LIB_VERSION,COPYRIGHT);
  libtpcroi_print_readme(fp);
  fprintf(fp,"\n</PRE> \n */\n");
}

/** 
    Print the library History to specified FILE pointer with Doxygen tags, 
    use stdout for screen.
*/
void libtpcroi_print_dhistory(FILE *fp)
{
  fprintf(fp,"/**\n\\page History\n\\section history History\n<PRE>\n");
  libtpcroi_print_history(fp);
  fprintf(fp,"\n</PRE> \n */\n");
}

/** 
    Print the build info to specified FILE pointer, use stdout for screen.
*/
void libtpcroi_print_build(FILE *fp)
{
  fprintf(fp,"\n %s %s %s\n",LIB_NAME,LIB_VERSION,COPYRIGHT);
  fprintf(fp,"\n Build %s %s\n",__DATE__,__TIME__);
}



/** Print the compilation date and time to specified FILE pointer  */
void libtpcroi_printdate(FILE *fp)
{
  libtpcroi_print_build(fp);
}

/*****************************************************************************/

