#include <stdio.h>
#include <stdlib.h>
#include <Xm/Xm.h>
#include <Xm/ToggleB.h>
#include "colorslide.h"
#include "main.h"
#include "colortables.h"
#include "yait.h"
#include "close_file.h"
#include "cursor.h"
#include "zoom_images.h"
#include "colormap.h"
#include "images.h"

/* Set a new colormap */
static void set_colormap(ColorScale map,int cmapN) {
  int low,high;
  my_SetWatchCursor(toplevel);
  low=studies[cmapN].c_lower;
  high=studies[cmapN].c_upper;
  colormap_setscaleN(XtDisplay(toplevel),map,low,high,cmapN);
  studies[cmapN].color=map;
  if(cmapN==0) {
    Arg cbcolorupdate[1];
    ImageList *images;
    XtSetArg(cbcolorupdate[0],XmNbackground,yait_palette[0][0].pixel);
    XtSetValues(display_area,cbcolorupdate,1);
    images=get_image_list();
    while(images) {
      XtSetValues((Widget)images->img->widget,cbcolorupdate,1);
      images=images->next;
    }
  }
  ColorslideUpdate(cmapN?color_bar2:color_bar);
  if(strlen(studies[0].filename)>4){
    if(zoom_matrix.zoom==0) {
      refresh_image_list(cmapN);
      update_matrix_view(cmapN);
    } else {
      refresh_zoom(cmapN);
    }
  }
  my_ResetCursor(toplevel);
}

/* Set a new primary colormap */
void color_cb(Widget widget, XtPointer client_data, XtPointer call_data) {
  set_colormap(((int)client_data),0);
}

/* Set a new secondary colormap */
void color2_cb(Widget widget, XtPointer client_data, XtPointer call_data) {
  set_colormap(((int)client_data),1);
}

/* Change color scaling mode (automatic, fixed + no negative) */
void color_scale_cb(Widget widget, XtPointer client_data, XtPointer call_data)
{
  int                      item_no = (int)client_data;

  my_SetWatchCursor(toplevel);

  switch(item_no){
     case 0:
       printf("colors: Automatic...\n");
       XmToggleButtonSetState(XtNameToWidget(XtParent(widget),"button_1"),XmUNSET,False);
       XmToggleButtonSetState(widget,XmSET,False);
       panels.scale=ScaleAutomatic;
       if(strlen(studies[0].filename)>4){
         if(zoom_matrix.zoom==0) {
           add_images(ScaleAutomatic,1);
	   update_matrix_view(-1);
         } else {
	   scale_image(zoom_matrix.zoom,zoom_matrix.interpolation);
         }
       }
       break;
     case 1:
       printf("colors: Fixed...\n");
       XmToggleButtonSetState(XtNameToWidget(XtParent(widget),"button_0"),XmUNSET,False);
       XmToggleButtonSetState(widget,XmSET,False);
       panels.scale=ScaleFixed;
       if(strlen(studies[0].filename)>4){
         if(zoom_matrix.zoom==0) {
	   add_images(ScaleFixed,1);
	   update_matrix_view(-1);
         } else {
	   scale_image(zoom_matrix.zoom,zoom_matrix.interpolation);
	 }
       }
       break;
     case 2:
       panels.no_neg_values=!panels.no_neg_values;
       if(strlen(studies[0].filename)) {
         if(zoom_matrix.zoom==0) {
           add_images(panels.scale,1);
           update_matrix_view(-1);
         } else {
           scale_image(zoom_matrix.zoom,zoom_matrix.interpolation);
         }
         message_area_info();
       }
       break;
     default:
       fprintf(stderr,"Warning: Unhandled color scale menu item %d !\n",item_no);
     break;
  }

  my_ResetCursor(toplevel);
}

/* Rescale the colormap when the user clicks on the palette widget */
void set_colorscale_cb(Widget widget, XtPointer client_data, XtPointer call_data) {
  ColorslideRescale *cbs=(ColorslideRescale*)call_data;
  int cmapN=(int)client_data;
  if(cbs->min_value>=0) {
    studies[cmapN].c_lower=cbs->min_value;
  }
  if(cbs->max_value>=0) {
    studies[cmapN].c_upper=cbs->max_value;
  }
  XtVaSetValues(widget,
  	ColorslideNminValue,studies[cmapN].c_lower,
  	ColorslideNmaxValue,studies[cmapN].c_upper,
  	NULL);
  show_color_table(studies[cmapN].c_lower,studies[cmapN].c_upper,cmapN);
}

