#ifndef COLORMAP_H
#define COLORMAP_H

#define PALETTE_COLORS 60

/* Allocate the colormap */
extern void allocate_colors(Display *display, int screen);

/* Set the colormap */
extern void colormap_setscale(Display *display,const float scale[][4],int scalelen,int min, int max,int cmapN);

/* Utility function to set the colormap by number */
extern void colormap_setscaleN(Display *display, int scaleN,int min,int max,int cmapN);

/* Convert a 8bit XImage to display format */
extern void screen_format_ximage_update(int len,int depth, unsigned char *srcdata, unsigned char *targdata,int cmapN);
extern XImage *screen_format_ximage(XImage *src,int cmapN);

/* This global holds the palette that is used to display the images	*/
/* If real palette cannot be acquired, the slower fallback option must	*/
/* be used where the image is redrawn every time the palette changes.	*/
extern XColor yait_palette[2][PALETTE_COLORS];

/* Display colordepth */
extern int displaydepth;

/* Does YaIT have read/write palette ? */
extern int haveRWpalette;

/* Some useful colors */
#define EXTRA_COLORS 2
#define RED 0
#define GREEN 1
extern XColor extra_palette[EXTRA_COLORS];

#endif

