#include <stdio.h>
#include <Xm/Xm.h>
#include <X11/Xutil.h>
#include "colorslidep.h"

#define X_PAD	20
#define Y_PAD	10

#define DrawGC(w) XmField(w,offsets,Colorslide,draw_GC,GC)
#define Foreground(w)   XmField(w,offsets,XmPrimitive,foreground,Pixel)
#define Highlighted(w) XmField(w,offsets,XmPrimitive,highlighted,Boolean)
#define BackgroundPixel(w) XmField(w,offsets,Core,background_pixel,Pixel)
#define RescaleCallback(w) XmField(w,offsets,Colorslide,rescaled,XtCallbackList)
#define Width(w) XmField(w,offsets,Core,width,Dimension)
#define Height(w) XmField(w,offsets,Core,height,Dimension)
#define ColorCount(w) XmField(w,offsets,Colorslide,colorcount,int)
#define Colors(w) XmField(w,offsets,Colorslide,colors,XColor*)
#define MinValue(w) XmField(w,offsets,Colorslide,min_value,int)
#define MaxValue(w) XmField(w,offsets,Colorslide,max_value,int)
#define BarWidth(w) XmField(w,offsets,Colorslide,barwidth,int)
#define CLeft(w) XmField(w,offsets,Colorslide,left,int)
#define CTop(w) XmField(w,offsets,Colorslide,top,int)
#define CHeight(w) XmField(w,offsets,Colorslide,height,int)

#define HighlightThickness(w) \
                XmField(w,offsets,XmPrimitive,highlight_thickness,Dimension)

static void ClassInitialize(void);
static void Initialize(ColorslideWidget request,ColorslideWidget new);
static void Redisplay(ColorslideWidget w,XEvent *event,Region region);
static void Resize(ColorslideWidget w);
static void Destroy(ColorslideWidget w);
static Boolean SetValues(ColorslideWidget current,ColorslideWidget request,ColorslideWidget new);
static XtGeometryResult QueryGeometry(ColorslideWidget w,XtWidgetGeometry *intended,XtWidgetGeometry *reply);

static void scale_colorslide(ColorslideWidget w, XEvent *event);

static char defaultTranslations[] =
   "<Btn1Motion>:         Scale()\n \
    <Btn1Down>:		  Scale()";

static XtActionsRec actionsList[] = {
    { "Scale", (XtActionProc) scale_colorslide}
};

static XmPartResource resources[] = {
	{ColorslideNminValue,ColorslideCMinValue,XtRInt,sizeof(int),
		XmPartOffset(Colorslide,min_value),XmRImmediate,(XtPointer)100},
	{ColorslideNmaxValue,ColorslideCMaxValue,XtRInt,sizeof(int),
		XmPartOffset(Colorslide,max_value),XmRImmediate,(XtPointer)100},
	{ColorslideNccount,ColorslideCCcount,XtRInt,sizeof(int),
		XmPartOffset(Colorslide,colorcount),XmRImmediate,(XtPointer)0},
	{ColorslideNentries,ColorslideCEntries,XtRPointer,sizeof(XtPointer),
		XmPartOffset(Colorslide,colors),XmRImmediate,NULL},
	{ColorslideNrescaled,XtCCallback,XtRCallback,sizeof(XtPointer),
		XmPartOffset(Colorslide,rescale_callback),XtRCallback,NULL},
};

ColorslideClassRec colorslideClassRec = {
    {                                   /* core_class fields    */
    (WidgetClass) &xmPrimitiveClassRec, /* superclass           */
    "Colorslide",                       /* class_name           */
    sizeof(ColorslidePart),             /* widget_size          */
    ClassInitialize,                    /* class_initialize     */
    NULL,                               /* class_part_initialize*/
    False,                              /* class_inited         */
    (void*)Initialize,                         /* initialize           */
    NULL,                               /* initialize_notify    */
    XtInheritRealize,                   /* realize              */
    actionsList,                        /* actions              */
    XtNumber(actionsList),              /* num_actions          */
    (XtResourceList)resources,          /* resources            */
    XtNumber(resources),                /* num_resources        */
    NULLQUARK,                          /* xrm_class            */
    True,                               /* compress_motion      */
    True,                               /* compress_exposure    */
    True,                               /* compress_enterleave  */
    False,                              /* visible_interest     */
    (void*)Destroy,                            /* destroy              */
    (void*)Resize,                             /* resize               */
    (void*)Redisplay,                          /* expose               */
    (void*)SetValues,                          /* set_values           */
    NULL,                               /* set_values_hook      */
    XtInheritSetValuesAlmost,           /* set_values_almost    */
    NULL,                               /* get_values_hook      */
    NULL,                               /* accept_focus         */
    XtVersionDontCheck,                 /* version              */
    NULL,                               /* callback_private     */
    defaultTranslations,                /* tm_table             */
    (void*)QueryGeometry,                      /* query_geometry       */
    NULL,                               /* disp accelerator     */
    NULL                                /* extension            */
    },
    {                                   /* primitive_class record */
    XmInheritWidgetProc,                /* border_highlight     */
    XmInheritWidgetProc,                /* border_unhighlight   */
    XtInheritTranslations,              /* translations         */
    (void*)scale_colorslide,                    /* arm_and_activate     */
    NULL,                               /* syn resources        */
    0,                                  /* num syn_resources    */
    NULL,                               /* extension            */
    },
    {                                   /* colorslide_class record  */
    0,/*NULL,*/                               /* extension            */
    }
};



static XmOffsetPtr offsets; /* Part Offset table for XmResolvePartOffsets */
externaldef(colorslidewidgetclass) WidgetClass colorslideWidgetClass = (WidgetClass) &colorslideClassRec;

/***********************************************\
| Class methods					|
\***********************************************/

static void create_GC(ColorslideWidget w)
{
    XGCValues       values;
    XtGCMask        valueMask;

    valueMask = GCForeground | GCBackground | GCGraphicsExposures;
    values.foreground = Foreground(w);
    values.background = BackgroundPixel(w);
    values.graphics_exposures = False;
    DrawGC(w) = XtGetGC((Widget)w,valueMask,&values);
}

static void ClassInitialize(void)
{
    XmResolvePartOffsets(colorslideWidgetClass, &offsets);
}

static void Initialize(ColorslideWidget request,ColorslideWidget new)
{
    if (Width(request) == 0)
        Width(new) = 100;
    if (Height(request) == 0)
        Height(new) = 50;
    create_GC(new);
    Resize(new);
}

static void Destroy(ColorslideWidget w)
{
    XtReleaseGC ((Widget)w, DrawGC(w));
    XtRemoveAllCallbacks ((Widget)w, ColorslideNrescaled);
}

static void Resize(ColorslideWidget w) {
  int x1,y1,x2,y2,barwidth,ccount;
  ccount=ColorCount(w);
  x1=X_PAD;
  y1=Y_PAD;
  x2=Width(w)-X_PAD*2;
  y2=Height(w)-Y_PAD*2;
  barwidth=(int)(((double)x2/(double)ccount)+0.5);
  if(barwidth==0) barwidth=1;
  x1=Width(w)/2-barwidth*(ccount/2);
  CLeft(w)=x1;
  CTop(w)=y1;
  CHeight(w)=y2;
  BarWidth(w)=barwidth;
}

static void draw_arrow(Display *d, Drawable win,GC *gc,int x,int y,char delta) {
  int dy;
  dy=delta;
  XDrawPoint(d,win,*gc,x,y);
  XDrawLine(d,win,*gc,x-1,y+dy,x+1,y+dy); dy+=delta;
  XDrawLine(d,win,*gc,x-2,y+dy,x+2,y+dy); dy+=delta;
  XDrawLine(d,win,*gc,x-3,y+dy,x+3,y+dy); dy+=delta;
}

static void Redisplay(ColorslideWidget w,XEvent *event,Region region)
{
  int left,right;
  int x1,y1,y2,barwidth,r,ccount;
  char str[3];
  XColor *colors;
  Drawable win;
  Display *d;
  GC gc;
  if (!XtIsRealized((Widget)w)) return;
  d=XtDisplay(w);
  win=XtWindow(w);
  gc=DrawGC(w);
  x1=CLeft(w);
  y1=CTop(w);
  y2=CHeight(w);
  barwidth=BarWidth(w);
  ccount=ColorCount(w);
  left=MinValue(w)*ccount/100*barwidth+x1;
  right=MaxValue(w)*ccount/100*barwidth+x1;
  colors=XmField(w,offsets,Colorslide,colors,XColor*);

  /* Draw a decorative frame */
  XSetForeground(d,gc,BlackPixel(d,DefaultScreen(d)));
  XDrawRectangle(d,win,gc,x1-1,y1-1,ccount*barwidth+1,y2+1);
  /* Draw numbers */
  sprintf(str,"%.3d",MinValue(w));
  XDrawString(d,win,gc,0,y2,str,3);
  sprintf(str,"%.3d",MaxValue(w));
  XDrawString(d,win,gc,x1+barwidth*ccount+5,y2,str,3);
  /* Draw arrows */
  draw_arrow(d,win,&gc,left,y1-2,-1);
  draw_arrow(d,win,&gc,right,y1+y2+1,1);
  /* Draw the palette */
  for(r=0;r<ccount;r++) {
    XSetForeground(d, gc, colors[r].pixel);
    XFillRectangle(d,win,gc,x1,y1,barwidth,y2);
    x1+=barwidth;
  }
}

static Boolean SetValues(ColorslideWidget current,ColorslideWidget request,ColorslideWidget new)
{
  return 1;
}

static XtGeometryResult QueryGeometry (ColorslideWidget w,XtWidgetGeometry *intended,XtWidgetGeometry *reply)
{
    reply->request_mode = 0;

    if ((intended->request_mode & (~(CWWidth | CWHeight))) != 0)
        return (XtGeometryNo);

    reply->request_mode = CWWidth;// | CWHeight);
    reply->width =  +	4*ColorCount(w) + 2+ 
                        2*HighlightThickness(w);
    //reply->height = MAX(MAX(down_height,up_height),bark_height) +
    //                    2*(ShadowThickness(w)+HighlightThickness(w));

    if (reply->width != intended->width ||
        reply->height != intended->height ||
        intended->request_mode != reply->request_mode)
        return (XtGeometryAlmost);
    else {
        reply->request_mode = 0;
        return (XtGeometryYes);
    }
}

/* TODO: Some fuzzy logic to decide whether the user wanted to move
   the min_value or max_value arrow */
static void scale_colorslide(ColorslideWidget w,XEvent *event) {
  int bar_width,ccount;
  int x,y,value;
  ColorslideRescale cbs;
  x=event->xbutton.x;
  y=event->xbutton.y;
  bar_width=XmField(w,offsets,Colorslide,barwidth,int);
  ccount=XmField(w,offsets,Colorslide,colorcount,int);
  if(x<X_PAD || x>Width(w)-X_PAD) return;
  value=(x-X_PAD)/bar_width/(double)ccount*100.0;
  if(y<Height(w)/2) {
    cbs.min_value=value<0?0:value;
    cbs.max_value=XmField(w,offsets,Colorslide,max_value,int);
  } else {
    cbs.min_value=XmField(w,offsets,Colorslide,min_value,int);
    cbs.max_value=value>100?100:value;
  }
  XtCallCallbacks ((Widget)w, ColorslideNrescaled, &cbs);
}


/* A public function to refresh the widget */
void ColorslideUpdate(Widget w) {
  Redisplay((ColorslideWidget)w,NULL,NULL);
}

