#ifndef COLORTABLES_H
#define COLORTABLES_H

typedef enum {GRAYSCALE,INVERSESCALE,RAINBOWSCALE,HEATSCALE,AIPSSCALE} ColorScale;
#define GRAYSCALE_LEN		2
#define INVERSESCALE_LEN	2
#define RAINBOWSCALE_LEN	9
#define HEATSCALE_LEN		5
#define AIPSSCALE_LEN		20

/* The scales */
	/* Position, Red, Green, Blue */
static const float gray_scale[GRAYSCALE_LEN][4]={
	{0.0, 0.0, 0.0, 0.0},
	{1.0, 1.0, 1.0, 1.0}
};

static const float inverse_scale[INVERSESCALE_LEN][4]={
	{0.0, 1.0, 1.0, 1.0},
	{1.0, 0.0, 0.0, 0.0}
};

static const float rainbow_scale[RAINBOWSCALE_LEN][4]={
	{-0.5, 0.0 , 0.0, 0.0},
	{0.0,  0.0 , 0.0, 0.3},
	{0.17, 0.0 , 0.0, 0.8},
	{0.35, 0.0 , 1.0, 1.0},
	{0.50, 0.6 , 1.0, 0.3},
	{0.67, 1.0 , 1.0, 0.0},
	{0.83, 1.0 , 0.6, 0.0},
	{1.0 , 1.0 , 0.0, 0.0},
	{1.7 , 1.0 , 1.0, 1.0}
};

static const float heat_scale[HEATSCALE_LEN][4]={
	{0.0, 0.0, 0.0, 0.0},
	{0.2, 0.5, 0.0, 0.0},
	{0.4, 1.0, 0.5, 0.0},
	{0.6, 1.0, 1.0, 0.3},
	{1.0, 1.0, 1.0, 1.0}
}; 

static const float aips_scale[AIPSSCALE_LEN][4]={
	{0.0, 0.0, 0.0, 0.0},
	{0.1, 0.0, 0.0, 0.0},
	{0.1, 0.3, 0.3, 0.3},
	{0.2, 0.3, 0.3, 0.3},
	{0.2, 0.5, 0.0, 0.7},
	{0.3, 0.5, 0.0, 0.7},
	{0.3, 0.0, 0.0, 0.7},
	{0.4, 0.0, 0.0, 0.7},
	{0.4, 0.0, 0.8, 0.9},
	{0.5, 0.0, 0.8, 0.9},
	{0.5, 0.0, 0.6, 0.0},
	{0.6, 0.0, 0.6, 0.0},
	{0.6, 0.0, 1.0, 0.0},
	{0.7, 0.0, 1.0, 0.0},
	{0.7, 1.0, 1.0, 0.0},
	{0.8, 1.0, 1.0, 0.0},
	{0.8, 1.0, 0.8, 0.0},
	{0.9, 1.0, 0.8, 0.0},
	{0.9, 1.0, 0.0, 0.0},
	{1.0, 1.0, 0.0, 0.0}
};

#endif

