#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>

#include "main.h"
#include "colormap.h"
#include "colortables.h"

void set_defaults()
{
  imagesPerRow=0;
  zoom_matrix.frame=0;
  zoom_matrix.plane=0;
  zoom_matrix.zoom=0;
  zoom_matrix.interpolation=1;  
  studies[0].c_lower=0;
  studies[0].c_upper=100;
  studies[1].c_lower=0;
  studies[1].c_upper=100;
  studies[0].color=RAINBOWSCALE;
  studies[1].color=GRAYSCALE;
  panels.scale=ScaleAutomatic;
  panels.no_neg_values=0; /* accept negative values */
  panels.show_matrix_rois=0; /* By default, don't show ROIs in the matrix view */
  panels.save_roi_studyn=0; /* Save ROIs according to first studys frame/plane numbers by default */
  panels.smoothroi=1;   /* Draw ROIs smoothly by default */

  strcpy( printer_name, "pet_color");
  strcpy( directory, ".");

  /* Initialize ROI list */
  roi_init(&roi_list); 

  /* Initialize image data type */
  imgInit(&studies[0].imagepack);
  imgInit(&studies[1].imagepack);

}


void reset_panel(void) {
  zoom_matrix.frame=0;
  zoom_matrix.plane=0;
  zoom_matrix.zoom=0;
#if 0
  zoom_matrix.interpolation=0;  
#endif
  studies[0].c_lower=0;
  studies[0].c_lower=0;
  studies[1].c_upper=100;
  studies[1].c_upper=100;
#if 0
  /* If we reset these, we should also set the apropriate checkmarks in the menu */
  panels.scale=ScaleAutomatic;
  panels.no_neg_values=0; /* accept negative values */
#endif
  
  /* Pitisik ROIt tyhjent jossain muualla ? */
  roi_empty(&roi_list);

  studies[0].filename[0]='\0';
  studies[1].filename[0]='\0';
  free(studies[0].planelist.i);
  studies[0].planelist.nr=0;
  free(studies[1].planelist.i);
  studies[1].planelist.nr=0;

  panels.panel_maxnum=0;
}

