#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include <time.h>
#include <img.h>
#include "main.h"
#include "message_dialog.h"
#include "roilist.h"

void calc_dev(IMG *imgpack,int matnum, ROI *roi, float *mean, float *dev)
{
  int               i=0, j, frame=1, plane=1, pxlNr=0;
  float             sum=0.0, tmp_sum,tmp_mean;
  char              **onoff;

  frame = matnum&0xFFF;
  frame-=1;
  plane = (matnum>>16)&0xFF;
  for(i=0; i<imgpack->dimz; i++){
    if(plane==imgpack->planeNumber[i]){
      plane=i;break;}
  }
  /* Allocate memory for onoff 
   */
  onoff=(char**)malloc(imgpack->dimy*sizeof(char*));
  if(onoff==NULL) {
      fprintf(stderr,"calc_dev(): onoff: Can't allocate %d bytes !\n",imgpack->dimy*sizeof(char*)); 
      fatal_error_dialog("Out of memory.");
      return;
  }
  for(j=0; j<imgpack->dimy; j++) {
      onoff[j]=(char*)malloc(imgpack->dimx*sizeof(char));
      if(onoff[j]==NULL) {
        fprintf(stderr,"calc_dev(): onoff[%d]: Can't allocate %d bytes !\n",j,imgpack->dimx*sizeof(char));
        fatal_error_dialog("Out of memory.");
        return;
      }
  }


  /* Fill onoff matrix for given ROI 
   */
  
  roi_onoff(roi, imgpack->dimx, imgpack->dimy,1,onoff);

  /* calculate mean first */
  for(i=0; i<imgpack->dimx; i++){ 
    for(j=0; j<imgpack->dimy; j++){
      if(onoff[i][j]){ 
	sum = sum + imgpack->m[plane][j][i][frame]; 
	pxlNr++;
      }
    }
  }
  
  tmp_mean = sum/(float)pxlNr;
  *mean = tmp_mean;

  sum=0.0;
  /* then calculate deviation */
  for(i=0; i<imgpack->dimx; i++){
    for(j=0; j<imgpack->dimy; j++){
      if(onoff[i][j]){
	tmp_sum=imgpack->m[plane][j][i][frame]-tmp_mean;
	sum+=tmp_sum*tmp_sum;
      }
    }
  }
  sum/=(float)(pxlNr); 
  *dev=sqrt(sum);

  /* Free used memory */
  for(i=0; i<imgpack->dimy; i++)
     free(onoff[i]);
  free(onoff);
 
}

