#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include "petimage.h"
#include "main.h"
#include "roiutils.h"
#include "double_roi.h"
#include "move_roi.h"
#include "roilist.h"
#include "message_dialog.h"
#include "zoom_images.h"

void double_roi_cb(Widget w, XtPointer client_data, XtPointer call_data) {
  ROI roi,*roiptr;
  XButtonEvent *event=call_data;
  move_roi_clientdata mc;
  XtVaGetValues(w,petimageNselectedRoi,&roiptr,NULL);
  if(roiptr==NULL) {
    set_ROI_drawmode(NULL,-1);
    message_dialog("Please select a ROI first","Double ROI");
    return;
  }
  memcpy(&roi,roiptr,sizeof(ROI));
  if(roi.x) {
    roi.x=(int*)malloc(sizeof(int)*roi.point_nr);
    memcpy(roi.x,roiptr->x,sizeof(int)*roi.point_nr);
  }
  if(roi.y) {
    roi.y=(int*)malloc(sizeof(int)*roi.point_nr);
    memcpy(roi.y,roiptr->y,sizeof(int)*roi.point_nr);
  }

  roi.status=0;
  strcat(roi.roiname,"_2");
  roiptr=put_roi_to_list(&roi,&roi_list);
  XtVaSetValues(w,petimageNselectedRoi,roiptr,NULL);
  PetimageHighlightRoi((PetimageWidget)w,roiptr,ROI_MOVE);
  mc.x=event->x;
  mc.y=event->y;
  XtRemoveCallback(w,petimageNmouseCb,double_roi_cb,NULL);
  /* Note. We pass move_roi_clientdata structure as a ROI. */
  /* We can do this because we know that it will be interpreted correctly */
  /* where it is going. This method might not be pretty, but it sure beats globals... */
  set_ROI_drawmode((ROI*)&mc,ROI_MOVE);
  XtVaSetValues(w,petimageNroiMode,roi.type+100,NULL);
}

