#ifndef EXPORT_H
#define EXPORT_H

typedef enum {EXPORT_BMP} ExportType;

typedef struct {
  ExportType type;
  int spacing;
  int imagesPerRow;
} ExportOptions;

/* Export menu callback */
extern void export_cb(Widget w, XtPointer client_data, XtPointer call_data);

/* Export the current view */
extern void export_image(Widget widget, XtPointer client_data, XtPointer call_data);
extern XImage *export_to_ximage(ExportOptions options);

/** export_dialog.c **/
/* Popup export dialog */
extern void export_dialog(ExportType type);

/* Popup export save dialog */
extern void export_save(ExportOptions *options);

#endif

