#include <stdlib.h>
#include <stdio.h>
#include <Xm/Xm.h>
#include <Xm/DialogS.h>
#include <Xm/PanedW.h>
#include <Xm/LabelG.h>
#include <Xm/RowColumn.h>
#include <Xm/Scale.h>
#include <Xm/SSpinB.h>
#include <Xm/FileSB.h>

#include "main.h"
#include "export.h"
#include "help_cb.h"
#include "util.h"

static void export_pushed (Widget w, XtPointer client_data, XtPointer call_data);

void export_dialog(ExportType type) {
  Widget dialog,pane,rc,action_a;
  Widget spacing,iperr;
  XmString string;
  Arg args[10];
  int n;
  static ActionAreaItem action_items[] = {
  	{"Export",export_pushed,NULL},
	{"Cancel",unmanage_cb,NULL},
	{"Help",help_cb,"Export the current view to file"}
  };
  /* Create DialogShell */
  n=0;
  switch(type) {
    case EXPORT_BMP:
      XtSetArg (args[n], XmNtitle, "Export BMP"); n++;
      break;
  }
  XtSetArg (args[n], XmNdeleteResponse, XmDESTROY); n++;
  dialog = XmCreateDialogShell (toplevel, "export_dialog", args, n);    
  action_items[0].data = (XtPointer) dialog;
  action_items[1].data = (XtPointer) dialog;
  /* Create control area */
  n=0;
  XtSetArg (args[n], XmNsashWidth, 1); n++;
  XtSetArg (args[n], XmNsashHeight, 1); n++;
  pane = XmCreatePanedWindow (dialog, "pane", args, n);
  rc = XmCreateRowColumn (pane, "control_area", NULL, 0);
  /* Create spacing label */
  n=0;
  string=XmStringCreateLocalized("Image spacing");
  XtSetArg(args[n],XmNlabelString,string); n++;
  XtManageChild(XmCreateLabelGadget(rc,"spacinglabel",args,n));
  XmStringFree(string);
  /* Create image spacing bar */
  n=0;
  XtSetArg (args[n], XmNmaximum, 30); n++;
  XtSetArg (args[n], XmNminimum, 0); n++;
  XtSetArg (args[n], XmNvalue, 15); n++;
  XtSetArg (args[n], XmNshowValue, True); n++;
  XtSetArg (args[n], XmNorientation,XmHORIZONTAL); n++;
  spacing = XmCreateScale(rc,"spacing",args,n);
  XtManageChild(spacing);
  /* Create images per row label */
  n=0;
  string=XmStringCreateLocalized("Images per row");
  XtSetArg(args[n],XmNlabelString,string); n++;
  XtManageChild(XmCreateLabelGadget(rc,"imagesperrowlabel",args,n));
  XmStringFree(string);
  /* Create images per row spinbox */
  n=0;
  XtSetArg (args[n], XmNmaximumValue, 100); n++;
  XtSetArg (args[n], XmNminimumValue, 1); n++;
  XtSetArg (args[n], XmNposition, 7); n++;
  XtSetArg (args[n], XmNeditable, False); n++;
  XtSetArg (args[n], XmNspinBoxChildType,XmNUMERIC); n++;
  XtSetArg (args[n], XmNshadowThickness,0); n++;

  iperr = XmCreateSimpleSpinBox(rc,"imagesperrow",args,n);
  XtManageChild(iperr);

  /* RowColumn is full -- now manage */
  XtManageChild (rc);
  /* Create the action area. */
  action_a = CreateActionArea (pane, action_items,XtNumber (action_items));
  XtManageChild (pane);
}

/* Show export save dialog */
void export_save(ExportOptions *options) {
  static Widget dialog=NULL;
  XmString directory,ttl,file_mask=NULL;
  Arg args[3];
  /* Create file selection dialog */
  if(!dialog){
    directory=XmStringCreateLocalized(".");
    ttl=XmStringCreateLocalized("Export image");
    XtSetArg(args[0], XmNpathMode, XmPATH_MODE_RELATIVE);
    XtSetArg(args[1], XmNdirectory, directory);
    XtSetArg(args[2],XmNdialogTitle,ttl);
    dialog=XmCreateFileSelectionDialog(toplevel,"export_filesel",args,3);
    XmStringFree(directory);
    XmStringFree(ttl);
    XtAddCallback(dialog, XmNcancelCallback, unmanage_cb, NULL);
    /* Help */   
    XtAddCallback(dialog, XmNhelpCallback, help_cb,NULL);
 }
 XtRemoveAllCallbacks(dialog,XmNokCallback);
 XtAddCallback(dialog, XmNokCallback, export_image, options);
 switch(options->type) {
   case EXPORT_BMP:
     file_mask=XmStringCreateLocalized("*.bmp");
     break;
 }
 XtSetArg(args[0],XmNpattern, file_mask);
 XtSetValues(dialog,args,1);
 XmStringFree(file_mask);
 XtManageChild(dialog);
 XtPopup(XtParent(dialog), XtGrabNone);
 XMapRaised(XtDisplay(dialog), XtWindow(XtParent(dialog)));
}

static void export_pushed (Widget w, XtPointer client_data, XtPointer call_data) {
  Widget w_spacing,w_iperr;
  ExportOptions *options;

  w_spacing=XtNameToWidget((Widget)client_data,"*spacing");
  w_iperr=XtNameToWidget((Widget)client_data,"*imagesperrow");

  options=malloc(sizeof(ExportOptions));
  options->type=EXPORT_BMP;
  XtVaGetValues(w_spacing,XmNvalue,&options->spacing,NULL);
  XtVaGetValues(w_iperr,XmNposition,&options->imagesPerRow,NULL);
  XtUnmanageChild((Widget)client_data);
  XtDestroyWidget((Widget)client_data);

  export_save(options);
}
