#include <stdio.h>
#include <stdlib.h>

#include <Xm/Xm.h>
#include <Xm/FileSB.h>
#include <Xm/MessageB.h>
#include <Xm/SelectioB.h>
#include <Xm/PushB.h>
#include <Xm/Text.h>
#include <Xm/TextF.h>
#include <img.h>
#include <imgfile.h>
#include "main.h"
#include "images.h"
#include "close_file.h"
#include "cursor.h"
#include "defaults.h"
#include "file_cb.h"
#include "help_cb.h"
#include "message_dialog.h"
#include "read_arg.h"
#include "util.h"
#include "print_dialog.h"
#include "zoom_images.h"

/* TODO: Tarvitaanko tt en ? Eik unmanage_cb riit ? */
void destroy_widget(Widget w, XtPointer client_data, XtPointer call_data)
{
  XtDestroyWidget(w);
  my_ResetCursor(toplevel);
}


/* Load an image file and pop up a dialog asking which frames/planes to show */
void mselection_cb(Widget w, XtPointer client_data, XtPointer call_data)
{
  char              *filename,error_msg[256];
  Arg               args[5];
  int               n = 0;
  int               ret;
  Widget            dialog;
  XmString          frames,title;
  XmFileSelectionBoxCallbackStruct *cbs =
     (XmFileSelectionBoxCallbackStruct *)call_data;
  Study *study = (Study*)client_data;

  /* Nm XmStringGetLtoR kutsut pitis vaihtaa kyttmn XmStringUnparsea */
  if(!XmStringGetLtoR(cbs->value, XmFONTLIST_DEFAULT_TAG, &filename))
    return;

  if(filename == NULL){
     return;
  }
  else strcpy(study->filename, filename);
  
  XmTextFieldSetString(message_w, "Loading...");
  my_SetWatchCursor(toplevel); 
  my_SetWatchCursor(w);

  /* Initialize image data type */
  imgEmpty(&study->imagepack);
 
  /* Read image file into IMG structure */
  ret=imgRead(study->filename,&study->imagepack);
  if(ret){
     sprintf(error_msg, "Can't read file: %s  (ret %d).\nReason: %s\n",
             study->filename, ret,study->imagepack.statmsg);
     error_dialog(error_msg);
     my_ResetCursor(toplevel);
     my_ResetCursor(w);
     XtUnmanageChild(w);
     return;
  }
  /* Check size */
  if(strlen(studies[1].filename)>=4) {
    if(studies[0].imagepack.dimx!=studies[1].imagepack.dimx ||
    	studies[0].imagepack.dimy!=studies[1].imagepack.dimy) {
      error_dialog("Different image dimensions !");
    }
  }
  /* Write information to message_area */
  message_area_info_study(study);

  /* Here goes how the frames, planes and gates are chosen.
   * Remember to allocate memory. */
  frames = XmStringCreateLocalized("Select matrixes:");
  title  = XmStringCreateLocalized("Load matrices");
  XtSetArg(args[n], XmNselectionLabelString, frames); n++;
  XtSetArg(args[n], XmNdialogTitle, title); n++;
  dialog = XmCreatePromptDialog(toplevel, "matrix_selection", args, n);
  XmStringFree(frames);
  XmStringFree(title);

  /* When the user types frame, plane and gate, call read_arg()*/
  XtAddCallback(dialog, XmNokCallback, read_arg, study);
  /* If the user selects cancel, just destroy the dialog */
  XtAddCallback(dialog, XmNcancelCallback, destroy_widget, NULL);
  /* Help */ 
  XtAddCallback(dialog, XmNhelpCallback, help_cb,
  	"Select matrices eg. 1-5 8,10-15\n\
	The 1-5 tells YaIT to load planes 1 to 5 and\n\
	8,10-15 to load from those frames, planes 8 and 10 to 15.");

  my_ResetCursor(toplevel);
  my_ResetCursor(w);

  XtManageChild(dialog);
  XtPopup(XtParent(dialog), XtGrabNone);

  XtUnmanageChild(w);

  free(filename);

}

/* Popup file selection box,clear,exit */
void file_cb(Widget widget, XtPointer client_data, XtPointer call_data)
{
  static Widget   fb_dialog;
  Arg             args[4];
  XmString        file_mask, dir,title;
  char            *dirtmp=NULL;
  RoiList	  *rl=roi_list.rois;
  switch((int)client_data) {
    case 0:
      if(zoom_matrix.zoom>0) {
        zoom_stop(0);
      }
      if(studies[0].filename[0]) {
        dirtmp=strrchr(studies[0].filename, '/');
        strncpy(directory, studies[0].filename, 
        strlen(studies[0].filename)-strlen(dirtmp)+1);
      }

      if(!fb_dialog){
        title=XmStringCreateLocalized("Open study");
        file_mask=XmStringCreateLocalized("*.img");
        XtSetArg(args[0], XmNpathMode, XmPATH_MODE_RELATIVE);
        XtSetArg(args[1], XmNpattern, file_mask);
        fb_dialog=XmCreateFileSelectionDialog(toplevel,
             "file_selection",args,2);
        XmStringFree(file_mask);
        XmStringFree(title);
        XtAddCallback(fb_dialog, XmNcancelCallback, unmanage_cb, NULL);
        XtAddCallback(fb_dialog, XmNokCallback, mselection_cb, &studies[0]);
        XtAddCallback(fb_dialog, XmNhelpCallback, help_cb,
            "Select an imagefile to be loaded.\n"
            "After the file has been loaded, you will be asked which\n"
            "frames and planes to display. Note that loading a file here will\n"
            "replace your existing study (if any) even if you do not display any frames !");
      } else {
        XtRemoveAllCallbacks(fb_dialog,XmNokCallback);
        XtAddCallback(fb_dialog, XmNokCallback, mselection_cb, &studies[0]);
      }
      dir=XmStringCreateLocalized(directory);
      title=XmStringCreateLocalized("Open study");
      XtSetArg(args[0], XmNdialogTitle,title);
      XtSetArg(args[1], XmNdirectory, dir);
      XtSetValues(fb_dialog,args,2);
      XmStringFree(dir);
      XmStringFree(title);

      XtManageChild(fb_dialog);
      XtPopup(XtParent(fb_dialog), XtGrabNone);
      /*XMapRaised(XtDisplay(fb_dialog), XtWindow(XtParent(fb_dialog)));*/
      break;
    case 1:
      printf("Open secondary study...\n"); 
      if(zoom_matrix.zoom>0) {
        zoom_stop(0);
      }
      if(strlen(studies[1].filename)>0){
        dirtmp=strrchr(studies[1].filename, '/');
        strncpy(directory, studies[1].filename, 
		strlen(studies[1].filename)-strlen(dirtmp)+1);
      }
      title=XmStringCreateLocalized("Open secondary study");
      dir=XmStringCreateLocalized(directory);
      XtSetArg(args[0], XmNdialogTitle,title);
      XtSetArg(args[1], XmNdirectory, dir);
      XtSetValues(fb_dialog,args,2);
      XmStringFree(title);
      XmStringFree(dir);
      XtRemoveAllCallbacks(fb_dialog,XmNokCallback);
      XtAddCallback(fb_dialog, XmNokCallback, mselection_cb, &studies[1]);
      XtManageChild(fb_dialog);
      /* What an earth next two lines do? */
      XtPopup(XtParent(fb_dialog), XtGrabNone);
      XMapRaised(XtDisplay(fb_dialog), XtWindow(XtParent(fb_dialog)));
      break;
    case 2:
      printf("printing...\n");
      print_dialog();
      break;
    case 3: break;
    case 4:
      while(rl) {
        if(rl->roi->status==0) {
          info_dialog("There are unsaved ROI(s).\n Clear anyway?","Close files", 1);
          return;
        }
        rl=rl->next;
      }
      clear_again(NULL,NULL,NULL);
      break;
    case 5: /* Laita tm vaikka jonnekin sammustuscallbackkiin */
      while(rl) {
        if(rl->roi->status==0) {
          info_dialog("There are unsaved ROI(s).\n Clear anyway?","Quit", 2);
	  return;
        }
	rl=rl->next;
      }
      quit_dialog("Really quit ?");
      break;
    default:
      fprintf(stderr,"file_cb(): Unknown menu id '%d' !\n",(int)client_data);
      break;
  }
}

/*
 * Clear images and ROIs
 */
void clear_again(Widget dialog, XtPointer client_data, XtPointer call_data)
{
  if(dialog)
    XtUnmanageChild (dialog);
  my_SetWatchCursor(toplevel);  
  if(zoom_matrix.zoom>0) {
    zoom_stop(0);
  }
  clear_display_area();
  imgEmpty(&studies[0].imagepack);
  imgEmpty(&studies[1].imagepack);
  reset_panel();
  XmTextFieldSetString(message_w, " ");
  my_ResetCursor(toplevel);
}


void quit_again(Widget dialog, XtPointer client_data, XtPointer call_data)
{
  char           message[256];
  printf("quit again\n");
  XtUnmanageChild (dialog);
  sprintf(message,"Really Quit?");
  quit_dialog(message); 
}

