#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include <unistd.h>
#include <Xm/Xm.h>
#include <Xm/FileSB.h>
#include <Xm/MessageB.h>
#include <Xm/SelectioB.h>
#include <Xm/RowColumn.h>
#include <Xm/ToggleB.h>
#include <Xm/PushB.h>
#include <Xm/Text.h>
#include <Xm/TextF.h>
#include <Xm/List.h>
#include <roi.h>
#include <img.h>
#include <ecat63.h>
#include "yait.h"
#include "/home/seppanea/prog/fractal/fractalD.h" /* TODO: ??? */
#include "message_dialog.h"

void fractal_cb(Widget widget, XtPointer client_data, XtPointer call_data)
{
  char                      *msg, *str=NULL, error_msg[256], roiname[256];
  char                      **onoff;
  int                       i,j, matnum;
  int                       cutoffRadius;
  int                       f_dim;
  unsigned long int         *nn;
  float                     **imageMatrix;
  float                     *complexVector;
  float                     *realVector;
  float                     *imVector;
  float                     *lnFreq, *lnDev;
  float                     d;                /*d=Deviation */
  float                     cutoffFrequency; 
  float                     FD;
  extern ROI_list           roi_list;
  extern panel_type         panels;
  extern IMG                image_pack;
  extern Widget             message_w;
  extern zoom_spanel        zoom_matrix; 

  printf("calculating FD\n");

  /* Check there's zoomed matrix and one ROI is activated 
   */
  msg=XmTextFieldGetString(message_w);
  if(strncmp(msg, "ROI:", 4)!=0 || zoom_matrix.zoom==0){
       sprintf(error_msg, "First activate a ROI at zoomed image.\n");
       error_dialog(error_msg);
       return;
  } 
  str=strchr(msg, ' '); if(str!=NULL){*str=(char)0; };   
  strcpy(roiname, msg+4);  
  printf("%s  %s\n", msg, roiname);

  /* Find ROI from ROI_list, find also plane and frame 
   */
  printf("frame:%d plane:%d\n", zoom_matrix.frame, zoom_matrix.plane);
  matnum=mat_numcod(zoom_matrix.frame, zoom_matrix.plane, 1, 0, 0);

  for(i=0; i<roi_list.nr; i++){
     if(roi_list.roi[i].matnum==matnum && 
        strcmp(roi_list.roi[i].roiname, msg+4)==0){
          printf("ROIlistan %d. ROI tsm\n", i);
	  break;
     }
  }
  /* If can not find the ROI, return 
   */

  /* Allocate onoff matrix and fill it 
   */
  onoff=(char**)calloc(panels.dim, sizeof(char*));
  if(onoff==NULL){
      sprintf(error_msg, "Error: out of memory.\n"); 
      error_dialog(error_msg);
      return;
  }
  roiOnOff(&roi_list.roi[i], panels.dim, panels.dim, 
            roi_list.roi[i].zoom, onoff);

  /* Allocate imageMatrix and fill it 
   */
  imageMatrix=(float**)calloc(panels.dim*panels.dim, sizeof(float));
  if(imageMatrix==NULL){
      sprintf(error_msg, "Error: out of memory.\n"); 
      error_dialog(error_msg);
      return;
  }
  for(i=0; i<panels.dim; i++){
    for(j=0; j<panels.dim; j++){
      imageMatrix[i][j]=
         image_pack.m[zoom_matrix.plane][i][j][zoom_matrix.frame];
    }
  }
  /* Allocate also other vectors needed
   */
  nn = (unsigned long *)malloc(2*sizeof(unsigned long));
  if( nn == NULL){ printf("Memory is full\n");
  return;}

  complexVector = (float*)calloc((1+2*panels.dim*panels.dim), sizeof(float));
  if(complexVector == NULL){ printf("Memory is full\n");
  return;}

  realVector = (float*)calloc(panels.dim*panels.dim, sizeof(float));
  if(realVector == NULL){ printf("Memory is full\n");
  return;}


  lnDev = (float*)calloc(1+panels.dim/2, sizeof(float));
  if(lnDev == NULL){ printf("Memory is full\n");
  return;}
  lnFreq = (float*)calloc(1+panels.dim/2, sizeof(float));
  if(lnFreq == NULL){ printf("Memory is full\n");
  return;}
  d = deviation(workVector);  /* valuates the deviation of ROI before */
  if(d > 0){                   /* filtering                            */
     lnDev[0]=log(d);
     lnFreq[0] = log (1/ sqrt(2));
  }
  else {
    return;
  }


  /* remove trend */
  remove_trend(imageMatrix, onoff, panels.dim);

  /* Add zeros */
  zero_filling(imageMatrix, onoff, panels.dim);

  /* find f_dim or max width of the ROI */
  f_dim=128;   /* Find in loop -> 2^k */


  /* FFT */
  nn[1]=(unsigned long int)f_dim;
  nn[2]=(unsigned long int)f_dim;
  vector_2_complex_vector(realVector, imVector, complexVector);
  fourn(complexVector, nn, 2, 1);
  complex_vector_2_vectors(realVector, imVector, complexVector);

  j=1;
  cutoffFrequency = 0.5;
  cutoffRadius = panels.dim/2;
  while (cutoffRadius > 0){
     /* filter for real & imag. vectors*/
     filtering(realVector, cutoffRadius);
     filtering(imVector, cutoffRadius);
     /* inverse FFT */
     vector_2_complex_vector(realVector, imVector, complexVector);
     fourn(complexVector, nn, 2, -1);
     /* normalize vector after FFT & FFT inverse */
     for(i=0; i<2*panels.dim*panels.dim ; i++) 
          complexVector[i+1]/=((float)2*panels.dim*panels.dim);
     complex_vector_2_vectors(realVector, imVector, complexVector);
     /* calculate variance */
     d=deviation_4_fd(imageMatrix, onoff, panels.dim);
     if(d > 0){                 
        lnDev[j]=log(d);
        lnFreq[j]=log(1.0/cutoffFrequency);
	j++;
     }   
     else {
       sprintf(error_msg,"Error: Can not valuate logarithm of deviation.\n"); 
       error_dialog(error_msg);
       return;
     }
     cutoffFrequency = cutoffFrequency - 1/(float)f_dim;
     cutoffRadius--;

  }

  /* estimate tho slope */
  /* FD=1-0.5*slope     */

  /* OR... find optimal slope minimizing correlation */
  FD=optimate_fd(lnFreq, lnDev, j);
  printf("FD=%f\n", FD);


  /* Free allocated memory */
  free(nn);
  free(imageMatrix);
  free(complexVector);
  free(realVector);
  free(imVector);
  free(lnFreq);
  free(lnDev);

 
  return;
}
