#include <stdio.h>
#include <Xm/Xm.h>
#include <Xm/MessageB.h>
#include "main.h"
#include "util.h"
#include "help_cb.h"

void helpmenu_cb(Widget widget, XtPointer client_data, XtPointer call_data) {
  switch((int)client_data) {
    case 0: /* Usage */
      help_cb(NULL,"Help system not yet finished",NULL);
      break;
    case 1: /* About */
      help_cb(NULL,"YaIT version " YAIT_VER "\nTurku PET Centre\n\nPetri Numminen\nAnne Seppnen\nCalle Laakkonen\n",NULL);
      break;
    default:
      fprintf(stderr,"helpmenu_cb(): Unknown menu item '%d' !\n",(int)client_data);
      break;
  }
}

void help_cb(Widget widget, XtPointer client_data, XtPointer call_data)
{
  Widget        dialog; 
  char          *help_text=(char *)client_data;
  Arg           args[2];
  int           n = 0;
  XmString      msg,ttl;

  if(help_text)
    msg = XmStringCreateLocalized(help_text);
  else
    msg = XmStringCreateLocalized("No help available");
  ttl = XmStringCreateLocalized("Help");
  XtSetArg(args[n], XmNmessageString, msg); n++;
  XtSetArg(args[n], XmNdialogTitle,ttl); n++;
  dialog = XmCreateInformationDialog(toplevel, "help_dialog", args, n);
  XmStringFree(msg);
  XmStringFree(ttl);

  XtUnmanageChild(XmMessageBoxGetChild(dialog, XmDIALOG_CANCEL_BUTTON));
  XtUnmanageChild(XmMessageBoxGetChild(dialog, XmDIALOG_HELP_BUTTON));
  XtAddCallback(dialog, XmNokCallback, unmanage_cb, dialog);

  XtManageChild(dialog);
}

