#ifndef IMAGES_H
#define IMAGES_H

#include "yait.h"
#include "petimage.h"

typedef struct {
  XImage *image;		/* Original 8bit */
  XImage *dimage;		/* Display format */
  PetimageWidget widget;	/* Widget for displaying the image */
  int studyN;			/* Study number (0 or 1) */
} YaIT_Image;

typedef struct _ImageList {
  YaIT_Image *img;
  struct _ImageList *prev;
  struct _ImageList *next;
} ImageList;

/* Refresh the image list with the new palette */
extern void refresh_image_list(int stydyN);

/* Reload the image list */
extern void update_image_list(Study *study);

/* Unload images */
extern void clear_images(void);

/* Add new/replace existing images in the list */
extern void add_images(ScaleType scale,char replace);

/* Get a pointer to the image list */
extern ImageList *get_image_list(void);

/* Get the seleced image */
extern YaIT_Image *get_selected_image(void);

/* Get the position of an image in the imagelist */
extern ImageList *find_image_pos(YaIT_Image *image);

/* Find an image */
extern YaIT_Image *find_image(int study,int frame,int plane);

/* Select an image */
extern int select_image_n(int study,int frame,int plane);

/* Find the frame/plane indexes to the IMG data */
/* Returns nonzero if not found */
extern int find_frame_plane_index(Study *study,int frame,int plane,int *iframe,int *iplane);

/* Update when colortable has changed */
extern void show_color_table(int d_limit, int u_limit,int cmapN);

/* Refresh the images in matrix view */
extern void update_matrix_view(int studyN);

/* Get the smallest and largest value from a matrix */
extern void get_minmax(Study *study,float *min,float *max);

/* Show information in message area */
extern void message_area_info(void);

/* Show info about a certain study in message area (no current frame/plane) */
extern void message_area_info_study(Study *study);

/* Find the image that will appear next to this one in zoomed view */
extern YaIT_Image *get_2nd_zoom_image(YaIT_Image *image);

/* Are there any negative pixel values */
extern void set_negative_values(int val);

#endif
