#include <stdio.h>
#include <stdlib.h>
#include <Xm/Xm.h>
#include <Xm/Text.h>
#include <Xm/TextF.h>
#include <Xm/List.h>
#include <Xm/SelectioB.h>
#include "main.h"
#include <ecat63.h>
#include <intex.h>

#include "roi_dialog.h"
#include "cursor.h"
#include "roilist.h"
#include "zoom_images.h"
#include "message_dialog.h"
#include "read_arg.h"

/* A callback for ROI list dialog. Handles ROI rename and delete */
void list_cb(Widget widget, XtPointer client_data, XtPointer call_data)
{
  int                   i;
  char                  message[256];
  XmAnyCallbackStruct   *cbs = (XmAnyCallbackStruct *) call_data;
  Widget		selected_rois;
  int			*selections,selcount,pos=1;
  RoiList		*list;
  /* Get the selections */
  selected_rois=XtNameToWidget(widget,"*selectedrois");
  XmListGetSelectedPos(selected_rois,&selections,&selcount);

  printf("In list_cb()\n");
  list=roi_list.rois;
  switch (cbs->reason){
    case XmCR_OK:
      printf("Rename selected\n");
      if(selcount==1) {
	while(pos<selections[0]) {list=list->next;pos++;}
	sprintf(message, "New name for ROI:'%s'",
          list->roi->roiname );
        rename_dialog(message, list->roi);
      } else {
	message_dialog("Choose only one ROI to rename!","Rename ROI");
      }
      break;
    case XmCR_CANCEL:
      printf("Delete selected (%d items selected)\n",selcount);
      for(i=0; i<selcount; i++) {
	roi_delete_n(&roi_list, selections[i]-1-i);
      }
      if(zoom_matrix.zoom) {
        PetimageUpdate(get_zoom_image()->widget[0]);
	PetimageUpdate(get_zoom_image()->widget[1]);
      }
      break;
    case XmCR_HELP :
      printf("Close selected\n");
      XtUnmanageChild(widget); 
      break;
  }
  free(selections);
}


/* Import the selected ROIs */
void read_roi_cb(Widget widget, XtPointer client_data, XtPointer call_data)
{ 
  int                           i, j, a, b;
  int                           plane, frame;
  INT_list                      frame_list, plane_list;
  char                          *matrix_str;
  ROI_list			*roilist=(ROI_list*)client_data;
  RoiList			*rois;
  XmSelectionBoxCallbackStruct  *cbs=
      (XmSelectionBoxCallbackStruct *) call_data;
  Widget			selected_rois;
  Widget			all_frames;
  char				to_all_frames;
  int				*selections;
  int				selcount;
  int				pos=1;
  /* Set cursor inactive */
  my_SetWatchCursor(toplevel);
  /* Get widgets */
  selected_rois=XtNameToWidget(widget,"*selectedrois");
  all_frames=XtNameToWidget(widget,"*load_to_all_frames");
  /* Get options */
  XtVaGetValues(all_frames,XmNset,&to_all_frames,NULL);
  to_all_frames=(to_all_frames==XmSET);
  XmListGetSelectedPos(selected_rois,&selections,&selcount);
  if(selcount==0) {
    my_ResetCursor(toplevel);
    message_dialog("No ROIs were selected !","Load ROI");
    return;
  }
  /* Initialize */
  rois=roilist->rois;
  plane_list.nr=0;
  frame_list.nr=0;
  matrix_str = (char*)malloc(512*(sizeof(char)));
  if(!XmStringGetLtoR(cbs->value, XmFONTLIST_DEFAULT_TAG, &matrix_str))
    return;
  strcat(matrix_str, " \n");
  if(strlen(matrix_str)>1) 
       read_matrix_sel(matrix_str, &frame_list, &plane_list);
  /* Load ROIs */
  if( plane_list.nr==0 &&  frame_list.nr==0){
    if(to_all_frames==0){ /* Load ROIs to their own frames/planes */
      for(i=0; i<selcount; i++) {
         while(pos<selections[i]) {rois=rois->next; pos++;}
         put_roi_to_list(rois->roi, &roi_list);
      }
    } else {
      /* load rois to all frames */
      for(i=0; i<selcount; i++){
         while(pos<selections[i]) { rois=rois->next; pos++; }
         plane = ((rois->roi->matnum>>16)&0xFF);
         for(j=0; j<studies[0].framelist.nr; j++){  
	    rois->roi->matnum=
              mat_numcod(studies[0].framelist.i[j], plane, 1, 0, 0);
            put_roi_to_list(rois->roi, &roi_list);
         }
      }
    }
  } else { /* Load ROIs to the user supplied frames/planes */
     for(i=0; i<selcount; i++){ 
       while(pos<selections[i]) { rois=rois->next; pos++; }
       plane = ((rois->roi->matnum>>16)&0xFF);
       if(plane_list.nr==0) {
         plane_list.nr=1;
	 plane_list.i=malloc(sizeof(int));
	 plane_list.i[0]=plane;
       }
       frame = (rois->roi->matnum&0xFFF);
       if(frame_list.nr==0) {
         frame_list.nr=1;
	 frame_list.i=malloc(sizeof(int));
	 frame_list.i[0]=frame;
       }
       for(a=0; a<frame_list.nr; a++) {
         printf("%d\t", frame_list.i[a]);
         for(b=0; b<plane_list.nr; b++){
           printf("%d\t", plane_list.i[b]);
           rois->roi->matnum = mat_numcod( frame_list.i[a], plane_list.i[b], 1, 0, 0);
	   rois->roi->status=0;
           put_roi_to_list(rois->roi, &roi_list);
	 }
       }
     }
  }
  /* Fix the ROI pairings */
  repair_rois(&roi_list);
  /* Cleanup */
  if(selcount) XtFree((char*)selections);
  roi_empty(roilist);
  free(roilist);
  free(selections);
  //if(zoom_matrix.zoom>0) update_zoom();
  my_ResetCursor(toplevel);

}

/* Copy the ROIs user selected */
void copy_roi_cb(Widget widget, XtPointer client_data, XtPointer call_data)
{
  int                          i, j, k;
  char                         *frame_str, *plane_str=NULL;
  XmSelectionBoxCallbackStruct *cbs=
                       (XmSelectionBoxCallbackStruct *) call_data;
  INT_list                     framelist;
  INT_list                     planelist;
  Widget			selected_rois;
  RoiList			*list;
  ROI				copy_roi;
  int				*selections,selcount;
  /* Get the selections */
  selected_rois=XtNameToWidget(widget,"*selectedrois");
  XmListGetSelectedPos(selected_rois,&selections,&selcount);
  /* Check that the user actually selected something */
  if(selcount==0) {
    message_dialog("No ROIs were selected","Copy ROI");
    return;
  }
  /* Initialize frame and plane lists */
  framelist.nr=0;
  planelist.nr=0;
  /* Allocate memory for strings */
  frame_str = (char*)malloc(512*(sizeof(char)));
  //plane_str = (char*)malloc(512*(sizeof(char)));
 
  /* read user's string (given in selection dialog) to frame */
  if(!XmStringGetLtoR(cbs->value, XmFONTLIST_DEFAULT_TAG, &frame_str))
    return;
  
  /* Try to understand, to which matrixes draw the ROIs */
  if(strlen(frame_str)>0){
     plane_str=strchr(frame_str, ' ');
     if(plane_str!=NULL){*plane_str=(char)0; plane_str++;}
  }
  else {
    error_dialog("Error: Give frames and planes where to copy\n");
    return;
  }
  printf("copy to frames %s, planes %s\n", frame_str, plane_str);
  if(strlen(plane_str)==0){
    error_dialog("Error: Give planes where to copy\n");
    return;
  }
  intExpand(plane_str, &planelist);
  intExpand(frame_str, &framelist);
  list=roi_list.rois;
  for(k=0; k<selcount; k++) {
    get_roi_from_list(&copy_roi, &roi_list, selections[k]-1);
    for(i=0; i<framelist.nr; i++){
      for(j=0; j<planelist.nr; j++){
	copy_roi.matnum=mat_numcod(framelist.i[i], planelist.i[j],1, 0, 0);
	/* put the new roi to list */
	put_roi_to_list(&copy_roi, &roi_list);
      }
    }
  }
  /* Cleanup */
  //free(plane_str);
  free(selections);
  free(frame_str);
  free(framelist.i);
  free(planelist.i);
  

}


void mirrorcopy_roi_cb(Widget     widget, XtPointer  client_data,  XtPointer  call_data) {
  int                          i, j, k, m;
  char                         *frame_str, *plane_str=NULL, *end;
  XmSelectionBoxCallbackStruct *cbs=
                       (XmSelectionBoxCallbackStruct *) call_data;
  Widget                       w=(Widget)client_data;
  INT_list                     framelist;
  INT_list                     planelist;
  char                         error_msg[256];
  ROI                          copy_roi;
  char				need_update=0;
  int 				curFrame,curPlane;
  Widget			selected_rois;
  int				*selections,selcount;
  /* Get the selections */
  selected_rois=XtNameToWidget(widget,"*selectedrois");
  XmListGetSelectedPos(selected_rois,&selections,&selcount);
  /* Check that the user actually selected something */
  if(selcount==0) {
    message_dialog("No ROIs were selected","Mirror copy ROI");
    return;
  }
  /* Initialize frame and plane lists */
  framelist.nr=0;
  planelist.nr=0;
  /* Allocate memory for strings */
  frame_str = (char*)malloc(512*(sizeof(char)));
  //plane_str = (char*)malloc(512*(sizeof(char)));
 
  /* read user's string (given in selection dialog) to frame */
  if(!XmStringGetLtoR(cbs->value, XmFONTLIST_DEFAULT_TAG, &frame_str))
    return;
  
  /* Try to understand, to which matrixes draw the ROIs */
  if(strlen(frame_str)>0){
     plane_str=strchr(frame_str, ' ');
     if(plane_str!=NULL){*plane_str=(char)0; plane_str++;}
  }
  else {
    sprintf(error_msg, "Error: Give frames and planes where to copy\n");
    error_dialog(error_msg);
    return;
  }
  printf("copy to frames %s, planes %s\n", frame_str, plane_str);
  if(strlen(plane_str)==0){
    sprintf(error_msg, "Error: Give planes where to copy\n");
    error_dialog(error_msg);
    return;
  }

  intExpand(plane_str, &planelist);
  intExpand(frame_str, &framelist);
  end=XmTextFieldGetString(w);

  XtVaGetValues((Widget)get_zoom_image_widget(),
  	petimageNframe,&curFrame,
	petimageNplane,&curPlane,
	NULL);

  for(k=0; k<selcount; k++){
    /* Get the roi to copy and mirror it */
    get_roi_from_list(&copy_roi, &roi_list, selections[k]-1);
    copy_roi.pos_x=studies[0].imagepack.dimx*copy_roi.zoom - copy_roi.pos_x;
    if(copy_roi.type==ROI_TRACE) {
      for(m=0; m<copy_roi.point_nr; m++)
	copy_roi.x[m]=-1*copy_roi.x[m];
    }
    //sprintf(copy_roi.roiname, "%s%s", copy_roi.roiname, end);
    strcat(copy_roi.roiname,end);
    for(i=0; i<framelist.nr; i++){
      for(j=0; j<planelist.nr; j++){
 	if(curFrame==framelist.i[i] && curPlane==planelist.i[i]) need_update=1;
	copy_roi.matnum=mat_numcod(framelist.i[i], planelist.i[j],1, 0, 0);
	put_roi_to_list(&copy_roi, &roi_list);
      }
    }
  }

  if(need_update) {
    PetimageUpdate(get_zoom_image_widget());
  }
  /* Cleanup */
  // free(plane_str);
  free(selections);
  free(frame_str);
  free(framelist.i);
  free(planelist.i);
  XtFree(end);
}


/* Select all ROIs toggle */
void selectall_cb(Widget widget, XtPointer client_data, XtPointer call_data)
{
  Arg                          args[3]; 
  int                          i, number=0;
  XmToggleButtonCallbackStruct *state =
                             (XmToggleButtonCallbackStruct *) call_data;
  Widget list_w = (Widget) client_data;


  i=0;
  XtSetArg (args[i], XmNitemCount, &number); i++;
  XtGetValues (list_w, args, i);
  
  if (state->set == XmSET){
     for(i=0; i<number; i++)
       XmListSelectPos (list_w, i+1, True);
  } else {
    XmListDeselectAllItems(list_w);
  }
}

