/****************************************************************************
 *                                                                          *
 *  main.c                                                                  *
 *  Petri Numminen    07.08.2002                                            * 
 *  Anne Seppnen     07.11.2002                                            *
 *  Calle Laakkonen   09.06.2003                                            *
 ****************************************************************************/

#include <stdio.h>
#include <stdlib.h>

#include <Xm/Xm.h>
#include <X11/Intrinsic.h>
#include <Xm/MainW.h>
#include <Xm/RowColumn.h>
#include <Xm/SpinB.h>
#include <Xm/SSpinB.h>
#include <Xm/PushB.h>
#include <Xm/ScrolledW.h>
#include <Xm/Form.h>
#include <Xm/Frame.h>
#include <Xm/Label.h>
#include <Xm/SeparatoG.h>
#include <Xm/CascadeB.h>
#include <Xm/SelectioB.h>
#include <Xm/Text.h>
#include <Xm/TextF.h>
#include <Xm/ToggleB.h>
#include <img.h>
#include "colorslide.h"	/* Colorslide widget */
#include "main.h"
#include "color.h"
#include "defaults.h"
#include "colortables.h"
#include "help_cb.h"
#include "interpolation_cb.h"
#include "read_config.h"
#include "message_dialog.h"
#include "zoom_images.h"
#include "spin_cb.h"
#include "file_cb.h"
#include "options_cb.h"
#include "zoom_cb.h"
#include "roi_cb.h"
#include "scroll_list.h"
#include "colormap.h"
#include "export.h"

/* Global variables
 */
char		printer_name[256], directory[256];
Widget		toplevel,main_w, display_area, message_w,message_w2, color_f, color_bar,color_bar2;
Widget		frame_spin, plane_spin;
Widget		matrix_widget;
panel_type	panels; 
zoom_spanel	zoom_matrix;
ROI_list	roi_list;
Study		studies[2];
int		imagesPerRow;

/* Internally used functions */
static void fill_control_panel(Widget control_panel);
static void create_menus(Widget menubar);
static Widget create_message_window(void);

/**************** 
 *    MAIN      *
 ****************/
int main(int argc, char *argv[])
{
  Widget           menubar, message_win,control_panel;
  XmString         file, options, roi, help;
  XtAppContext     app;
  int 		   r;
  /* Set defaults */
  set_defaults(); 
 
  /* Open the application */
  XtSetLanguageProc(NULL, NULL, NULL);
  toplevel = XtVaOpenApplication(&app, "toplevel", NULL,
    0, &argc, argv, NULL, sessionShellWidgetClass,
    XmNwidth,  WIDTH,
    XmNheight, HEIGHT,
    XmNtitle,  PROGRAM,
    //XmNiconic, True,
    NULL);

  /* Parse command line arguments */
  for(r=1;r<argc;r++) {
    if(strcmp(argv[r],"--help")==0) {
      printf("Yet another ImageTool %s\nUsage:\n",YAIT_VER);
      printf("\t--help\t\t\tShow this message\n");
      printf("\t--config <yait.cfg>\tSet the configuration file to use\n");
      printf("\t-V\t\t\tDisplay version information\n");
      printf("\n");
      return 0;
    } else if(strcmp(argv[r],"--config")==0) {
      r++;
      if(r==argc) {
        printf("Please specify the configuration file !\n");
        return 0;
      }
      read_config(argv[r]);	/* Read configuration file */
    } else if(strcmp(argv[r],"-V")==0) {
        puts(PROGRAM);
        printf("roi module version: %s\n",libpet_roi_version());
        return 0;
    } else printf("Unknown option: \%s\n",argv[r]);
  }
 
  /* Create main window 
   */
  main_w = XtVaCreateManagedWidget("main_window",
#ifdef BUGGY_MAINWINDOW
       xmFormWidgetClass, toplevel,
#else
       xmMainWindowWidgetClass,toplevel,
       XmNscrollBarDisplayPolicy,XmAS_NEEDED,
       XmNscrollingPolicy,XmAUTOMATIC,
       XmNcommandWindowLocation,XmCOMMAND_ABOVE_WORKSPACE,
#endif
       NULL);
  
  /* Initialize colormap
   */
  allocate_colors(XtDisplay(main_w),XDefaultScreen(XtDisplay(main_w)));

  /* Create menubar 
   */
  file    = XmStringCreateLocalized("File");
  options = XmStringCreateLocalized("Options");
  roi     = XmStringCreateLocalized("ROI");
  help    = XmStringCreateLocalized("Help");
  menubar = XmVaCreateSimpleMenuBar(main_w, "menubar",
#ifdef BUGGY_MAINWINDOW
	XmNbottomAttachment, XmATTACH_NONE,
        XmNrightOffset, 0,
        XmNrightAttachment, XmATTACH_FORM,
        XmNleftOffset, 0,
        XmNleftAttachment, XmATTACH_FORM,
        XmNtopOffset, 0,
        XmNtopAttachment, XmATTACH_FORM,
        XmNallowResize, True,
        XmNresizePolicy, XmRESIZE_ANY ,
#else
  	XmNscrolledWindowChildType, XmMENU_BAR,
#endif
        XmVaCASCADEBUTTON, file, 'F',
        XmVaCASCADEBUTTON, options, 'm',
        XmVaCASCADEBUTTON, roi, 'R',
        XmVaCASCADEBUTTON, help, 'H',
        NULL); 
  XmStringFree(file);
  XmStringFree(options);
  XmStringFree(roi);
  XmStringFree(help);

  /* call create_menus to make pulldown menus for every cascade button */  
  create_menus(menubar);

  /* Create control panel (Form widget) below the menubar 
   */
  control_panel=XtVaCreateWidget("control_panel", 
	xmFormWidgetClass, main_w, 

#ifdef BUGGY_MAINWINDOW
	XmNbottomAttachment, XmATTACH_NONE,
	XmNrightOffset, 0,
	XmNrightAttachment, XmATTACH_FORM,
	XmNleftOffset, 0,
	XmNleftAttachment, XmATTACH_FORM,
	XmNtopOffset, 30,
	XmNtopAttachment, XmATTACH_FORM,
	XmNresizePolicy, XmRESIZE_GROW,
	XmNmarginHeight, 0,
	XmNmarginWidth, 0,
//	XmNheight, 40,
#else
       XmNscrolledWindowChildType, XmCOMMAND_WINDOW,
#endif
       NULL);
  /* call fill_control_panel to make objects to control panel */
  fill_control_panel(control_panel);

  /* Create display area
   */
  display_area = XtVaCreateWidget("display_area",
#ifdef BUGGY_MAINWINDOW
	xmScrolledWindowWidgetClass,main_w,
	XmNrightOffset, 0,
	XmNrightAttachment, XmATTACH_FORM,
	XmNleftOffset, 0,
	XmNleftAttachment, XmATTACH_FORM,
	XmNtopOffset, 70,
	XmNtopAttachment, XmATTACH_FORM,
	XmNbottomOffset, 20,
	XmNbottomAttachment, XmATTACH_FORM,
	XmNresizePolicy, XmRESIZE_GROW,
	XmNscrolledWindowMarginHeight,3,
	XmNscrollBarDisplayPolicy,XmAS_NEEDED,
	XmNscrollingPolicy,XmAUTOMATIC,
#else
	xmFormWidgetClass,main_w,
	XmNscrolledWindowChildType, XmWORK_AREA,
#endif 
     NULL);
#ifdef BUGGY_MAINWINDOW
  matrix_widget=XmCreateForm(display_area,"matrix_display",NULL,0);
#else
  matrix_widget=display_area;
#endif
  XtVaSetValues(matrix_widget,XmNbackground,yait_palette[0][0].pixel,NULL);
  /* Create the footer as message area of main_w 
   */
   message_win=create_message_window();
#if 0
  message_w = XtVaCreateWidget(  "Message",
	xmTextFieldWidgetClass,   main_w,
	XmNmarginHeight, 0,
	XmNmarginWidth, 0,
	XmNeditable, False,
	XmNcursorPositionVisible, False, 
	XmNshadowThickness, 0,
	XmNtraversalOn,FALSE,
#ifdef BUGGY_MAINWINDOW
	XmNbottomOffset, 0,
	XmNbottomAttachment, XmATTACH_FORM,
	XmNrightOffset, 0,
	XmNrightAttachment, XmATTACH_FORM,
	XmNleftOffset, 0,
	XmNleftAttachment, XmATTACH_FORM,
#else
	XmNscrolledWindowChildType, XmMESSAGE_WINDOW,
#endif
	NULL);
#endif
  /* Initialize zoomed image display */
  init_zoom_images();

  /* Manage children and realize toplevel 
   */  
  XtManageChild(menubar);
  XtManageChild(control_panel);
  XtManageChild(display_area);
#ifdef BUGGY_MAINWINDOW
  XtManageChild(matrix_widget);
#endif
  XtManageChild(message_win);

  XtVaSetValues(main_w,
  	XmNmenuBar,menubar,
	XmNcommandWindow,control_panel,
  	XmNworkWindow,display_area,
	XmNmessageWindow,message_win,
	NULL);

  XtRealizeWidget(toplevel);
  
  /* Interact with the user 
   */
  XtAppMainLoop(app);
  return 0;

}

/***************************************************************
 * Create the message bar
 */

static Widget create_message_window(void) {
  Widget msgw;
  msgw = XtVaCreateWidget("MessageWindow",
  	xmFormWidgetClass,main_w,
	XmNfractionBase,5,
#ifdef BUGGY_MAINWINDOW
	XmNbottomOffset, 0,
	XmNbottomAttachment, XmATTACH_FORM,
	XmNrightOffset, 0,
	XmNrightAttachment, XmATTACH_FORM,
	XmNleftOffset, 0,
	XmNleftAttachment, XmATTACH_FORM,
#else
	XmNscrolledWindowChildType, XmMESSAGE_WINDOW,
#endif
	NULL);

  message_w = XtVaCreateWidget(  "Message",
	xmTextFieldWidgetClass,   msgw,
	XmNmarginHeight, 0,
	XmNmarginWidth, 0,
	XmNeditable, False,
	XmNcursorPositionVisible, False, 
	XmNshadowThickness, 0,
	XmNtraversalOn,FALSE,
	//XmNwidth,WIDTH-100,
	XmNleftAttachment,XmATTACH_FORM,
	XmNrightAttachment,XmATTACH_POSITION,
	XmNrightPosition,4,
	NULL);
  message_w2 = XtVaCreateWidget(  "Message2",
	xmTextFieldWidgetClass,   msgw,
	XmNmarginHeight, 0,
	XmNmarginWidth, 0,
	XmNeditable, False,
	XmNcursorPositionVisible, False, 
	XmNshadowThickness, 0,
	XmNtraversalOn,FALSE,
	XmNrightAttachment,XmATTACH_FORM,
	XmNleftAttachment,XmATTACH_WIDGET,
	XmNleftWidget,message_w,
	XmNwidth,100,
	NULL);

  XtManageChild(message_w);
  XtManageChild(message_w2);
  return msgw;
}

/***************************************************************
 *  fill_control_panel function creates objects to control panel
 *  spinboxes etc.
 */
void fill_control_panel(Widget control_panel)
{
  Widget   framelabel_w, planelabel_w;       
  XmString label_str1, label_str2;
  XmStringTable    str;
  Arg arg[11];
  int argN=0;
  str = (XmStringTable) XtMalloc (sizeof (XmString *));
  str[0] = XmStringCreateLocalized ("1");

   /* Write "Frame:" before spinbox 
    */
   label_str1 = XmStringCreateLocalized("Frame:");
   framelabel_w = XtVaCreateWidget("textfield_label",
	 xmLabelWidgetClass,  control_panel,
         XmNbottomAttachment, XmATTACH_NONE,
	 XmNrightAttachment, XmATTACH_NONE,
         XmNleftOffset, 20,
         XmNleftAttachment, XmATTACH_FORM,
         XmNtopOffset, 15,
         XmNtopAttachment, XmATTACH_FORM,
	 XmNlabelString, label_str1,
	 NULL);
   XmStringFree(label_str1);


   /* Create the SpinBox for frame 
    */
   XtSetArg(arg[argN],XmNcolumns,2); argN++;
   XtSetArg(arg[argN],XmNnumValues,1); argN++;
   XtSetArg(arg[argN],XmNeditable,False); argN++;
   XtSetArg(arg[argN],XmNvalues,str); argN++;
   XtSetArg(arg[argN],XmNspinBoxChildType,XmSTRING); argN++;
   XtSetArg(arg[argN],XmNwrap,False); argN++;
   XtSetArg(arg[argN],XmNshadowThickness,0); argN++;
   XtSetArg(arg[argN],XmNtopOffset, 5); argN++;
   XtSetArg(arg[argN],XmNtopAttachment, XmATTACH_FORM); argN++;
   XtSetArg(arg[argN],XmNleftAttachment,XmATTACH_WIDGET); argN++;
   XtSetArg(arg[argN],XmNleftWidget,framelabel_w); argN++;
   frame_spin=XmCreateSimpleSpinBox(control_panel,"spin_frame",arg,argN);

   XtAddCallback(frame_spin, XmNvalueChangedCallback, spin_cb, NULL);


   /* Write "Plane:" before spinbox 
    */
   label_str2 = XmStringCreateLocalized("Plane:");
   planelabel_w = XtVaCreateWidget("textfield_label",
	 xmLabelWidgetClass,  control_panel,
         XmNbottomAttachment, XmATTACH_NONE,
	 XmNrightAttachment, XmATTACH_NONE,
         XmNleftOffset, 200,
         XmNleftAttachment, XmATTACH_FORM,
         XmNtopOffset, 15,
         XmNtopAttachment, XmATTACH_FORM,
	 XmNlabelString, label_str2,
	 NULL);
   XmStringFree(label_str2);

   /* Create the SpinBox for plane 
    */
   XtSetArg(arg[argN-1],XmNleftWidget,planelabel_w);
   plane_spin=XmCreateSimpleSpinBox(control_panel,"spin_plane",arg,argN);

   XtAddCallback(plane_spin, XmNvalueChangedCallback, spin_cb, NULL);

   XmStringFree (str[0]);
   XtFree ((XtPointer) str);

   /* 
    * Create the color frame
    */
   argN=0;
   XtSetArg(arg[argN],XmNrightAttachment,XmATTACH_FORM); argN++;
   //colorframe = XmCreateForm (control_panel, "colorframe", arg, argN);

   color_bar=XtVaCreateWidget("color_bar",
	colorslideWidgetClass,control_panel,
	XmNwidth,285,
	XmNheight,42,
	XmNtraversalOn,FALSE,
	ColorslideNminValue,0,
	ColorslideNmaxValue,100,
	ColorslideNentries,yait_palette[0],
	ColorslideNccount,PALETTE_COLORS,
	XmNtopAttachment,XmATTACH_FORM,
	XmNrightAttachment,XmATTACH_WIDGET,
	XmNrightOffset,15,
	NULL);
   XtAddCallback(color_bar,ColorslideNrescaled,(void*)set_colorscale_cb,(void*)0);
   /*
    * Create colorframe, secondary study
    */
   color_bar2=XtVaCreateWidget("color_bar2",
	colorslideWidgetClass,control_panel,
	XmNwidth,285,
	XmNheight,42,
	XmNtraversalOn,FALSE,
	ColorslideNminValue,0,
	ColorslideNmaxValue,100,
	ColorslideNentries,yait_palette[1],
	ColorslideNccount,PALETTE_COLORS,
	XmNtopAttachment,XmATTACH_FORM,
	XmNrightAttachment,XmATTACH_FORM,
	NULL);
   XtVaSetValues(color_bar,XmNrightWidget,color_bar2,NULL);
   XtAddCallback(color_bar2,ColorslideNrescaled,(void*)set_colorscale_cb,(void*)1);

   /* Manage all children of control_panel 
    */
   XtManageChild (framelabel_w);
   XtManageChild (planelabel_w); 
   XtManageChild (frame_spin);
   XtManageChild (plane_spin); 
   XtManageChild (color_bar);
#if 1	/* Show these only when needed */
   XtManageChild (color_bar2);
#endif
}


/*******************************************************************
 *  create_menus fuction creates pulldown menus for cascade buttons
 *  in menubar
 */
void create_menus(Widget menubar)
{
  Widget        widget, options_menu, color_m, scale_menu, color_menu,color2_menu;
  Widget        zoom_menu, interpolation_menu;
  Widget        filemenu,roi_menu, draw_menu, roitools_menu,file_menu;
  Widget	roisavemenu,help_menu,export_menu;
  XmString      open,open2, print,export, clear, quit;
  XmString      colors, zoom, new_select,new_select2;
  XmString      show_all,zoom1, zoom2, zoom3, zoom4, zoom5,zoom6,zoom10;
  XmString      interpolation, none, linear; 
  XmString      scale, automatic, fixed, no_negative, map,map2;
  XmString      trace, rectangle, circle, ellipse, rotate, move,
                 copy, mirror_copy, doubling,convertroi,profile;
  XmString      save_roi, retrieve;
  XmString	save_roi_to,roi_1st,roi_2nd;
  XmString      usage, about;
  XmString      draw, tools,file, list,showinmatrix,smoothroi;
  XmString      gray, inverse, rainbow, heat, AIPS;
  XmString     /* save_acc, load_acc, */ quit_acc;
  XmString	export_bmp;
  char		tmpstr[10];
  /* Create pulldown menu for File-button 
   */
  open  = XmStringCreateLocalized("Open...");
  open2 = XmStringCreateLocalized("Open secondary...");
  print = XmStringCreateLocalized("Print...");
  export = XmStringCreateLocalized("Export");
  clear = XmStringCreateLocalized("Clear");
  quit  = XmStringCreateLocalized("Quit");
  quit_acc = XmStringCreateLocalized ("Ctrl-Q");
  filemenu=XmVaCreateSimplePulldownMenu(menubar, "filemenu", 0, file_cb,
    XmVaPUSHBUTTON, open,  'O', "Ctrl<Key>o", NULL,
    XmVaPUSHBUTTON, open2, 's', "Ctrl<Key>s", NULL,
    XmVaPUSHBUTTON, print, 'p', NULL, NULL,
    XmVaCASCADEBUTTON, export, 0, 
    XmVaPUSHBUTTON, clear, 'c', NULL, NULL,
    XmVaSEPARATOR,
    XmVaPUSHBUTTON, quit, 'Q', "Ctrl<Key>q", quit_acc, 
    NULL);
  XtSetSensitive(XtNameToWidget(filemenu,"button_1"),False);
  XtSetSensitive(XtNameToWidget(filemenu,"button_2"),False);
  XtSetSensitive(XtNameToWidget(filemenu,"button_3"),False);
  XtSetSensitive(XtNameToWidget(filemenu,"button_4"),False);


  XmStringFree(open); 
  XmStringFree(open2);
  XmStringFree(print);
  XmStringFree(export);
  XmStringFree(clear);
  XmStringFree(quit);
  XmStringFree(quit_acc);
  /* Create pulldown menu for Export-button
   */
  export_bmp = XmStringCreateLocalized("BMP...");
  export_menu = XmVaCreateSimplePulldownMenu(filemenu, "exportmenu", 
	3, export_cb,
	XmVaPUSHBUTTON, export_bmp, 0, NULL, NULL,
	NULL);
  XmStringFree(export_bmp);
  /* Create pulldown menu for Options-button 
   */
  colors     = XmStringCreateLocalized("Colors");
  interpolation = XmStringCreateLocalized("Interpolation");
  zoom = XmStringCreateLocalized("Zoom");
  new_select   = XmStringCreateLocalized("Select again...");
  new_select2  = XmStringCreateLocalized("Select secondary again...");
  
  options_menu = XmVaCreateSimplePulldownMenu(menubar, "optionsmenu", 
      1, options_cb,
      XmVaCASCADEBUTTON, colors, '2',
      XmVaCASCADEBUTTON, interpolation, '2',
      XmVaCASCADEBUTTON, zoom, '2',
      XmVaSEPARATOR,
      XmVaPUSHBUTTON, new_select, '2', NULL, NULL,
      XmVaPUSHBUTTON, new_select2, '2', NULL,NULL,
      NULL);
  XtSetSensitive(XtNameToWidget(options_menu,"button_2"),False);	/* Zoom */
  XtSetSensitive(XtNameToWidget(options_menu,"button_3"),False);	/* Select again */
  XtSetSensitive(XtNameToWidget(options_menu,"button_4"),False);	/* Select secondary again */

  XmStringFree(colors);
  XmStringFree(interpolation);
  XmStringFree(zoom);
  XmStringFree(new_select);

  /* Create  pulldown menu for color -button 
   */
  scale    = XmStringCreateLocalized("Scale");
  map   = XmStringCreateLocalized("Map");
  map2  = XmStringCreateLocalized("Secondary map");
  color_m = XmVaCreateSimplePulldownMenu(options_menu, "color_menu", 
      0, color_cb,
      XmVaCASCADEBUTTON, scale, 's',
      XmVaCASCADEBUTTON, map, 'm',
      XmVaCASCADEBUTTON, map2, 'M',
      NULL);
  XmStringFree(scale);
  XmStringFree(map);
  /* Create  pulldown menu for color scale-button 
   */
  automatic   = XmStringCreateLocalized("Automatic");
  fixed       = XmStringCreateLocalized("Fixed");
  no_negative = XmStringCreateLocalized("No negative values");
  scale_menu  = XmVaCreateSimplePulldownMenu(color_m, "scale_menu", 
      0, color_scale_cb,
      XmVaRADIOBUTTON, automatic, '1',NULL, NULL,
      XmVaRADIOBUTTON, fixed, '1', NULL, NULL,
      XmVaSEPARATOR,
      XmVaTOGGLEBUTTON, no_negative, '1', NULL, NULL,	   
      NULL);
  XmToggleButtonSetState(XtNameToWidget(scale_menu,panels.scale==ScaleAutomatic?"button_0":"button_1"),XmSET,False);
  if(panels.no_neg_values) XmToggleButtonSetState(XtNameToWidget(scale_menu,"button_2"),XmSET,False);

  XmStringFree(automatic);
  XmStringFree(fixed);
  XmStringFree(no_negative);
  /* Create  pulldown menu for color maps-button 
   */
  gray    = XmStringCreateLocalized("Gray");
  inverse = XmStringCreateLocalized("Inverse");
  rainbow = XmStringCreateLocalized("Rainbow");
  heat    = XmStringCreateLocalized("Heat");
  AIPS    = XmStringCreateLocalized("AIPS");
  color_menu  = XmVaCreateSimplePulldownMenu(color_m, "colormenu", 
      1, color_cb,
      XmNradioBehavior,True,
      XmVaRADIOBUTTON, gray,     'g', NULL, NULL,
      XmVaRADIOBUTTON, inverse,  'i', NULL, NULL,
      XmVaRADIOBUTTON, rainbow , 'r', NULL, NULL,
      XmVaRADIOBUTTON, heat ,    'h', NULL, NULL,
      XmVaRADIOBUTTON, AIPS,     'P', NULL, NULL,
      NULL);
  sprintf(tmpstr,"button_%d",studies[0].color);
  XmToggleButtonSetState(XtNameToWidget(color_menu,tmpstr),XmSET,False);

  color2_menu = XmVaCreateSimplePulldownMenu(color_m,"color2menu",
      2,color2_cb,
      XmNradioBehavior,True,
      XmVaRADIOBUTTON, gray,     'G', NULL, NULL,
      XmVaRADIOBUTTON, inverse,  'I', NULL, NULL,
      XmVaRADIOBUTTON, rainbow , 'R', NULL, NULL,
      XmVaRADIOBUTTON, heat ,    'H', NULL, NULL,
      XmVaRADIOBUTTON, AIPS,     'P', NULL, NULL,
      NULL);
  sprintf(tmpstr,"button_%d",studies[1].color);
  XmToggleButtonSetState(XtNameToWidget(color2_menu,tmpstr),XmSET,False);

  XmStringFree(gray); 
  XmStringFree(inverse); 
  XmStringFree(rainbow);
  XmStringFree(heat);
  XmStringFree(AIPS);

  /* Create interpolation menu
   */
  none    = XmStringCreateLocalized("None"); 
  linear  = XmStringCreateLocalized("Linear");  
  interpolation_menu=XmVaCreateSimplePulldownMenu(options_menu, "interpolation_menu", 
      1, interpolation_cb,
      XmNradioBehavior,True,
      XmVaRADIOBUTTON, none, '1',NULL, NULL,
      XmVaRADIOBUTTON, linear, '1',NULL, NULL,			   
      NULL); 
  XmStringFree(none);
  XmStringFree(linear);
  XmToggleButtonSetState(XtNameToWidget(interpolation_menu,zoom_matrix.interpolation?"button_1":"button_0"),XmSET,False);

  /* Create menu for zooms
   */
  show_all = XmStringCreateLocalized("Show all");
  zoom1 = XmStringCreateLocalized("Zoom 1");
  zoom2 = XmStringCreateLocalized("Zoom 2");
  zoom3 = XmStringCreateLocalized("Zoom 3");
  zoom4 = XmStringCreateLocalized("Zoom 4");
  zoom5 = XmStringCreateLocalized("Zoom 5");
  zoom6 = XmStringCreateLocalized("Zoom 6");
  zoom10 = XmStringCreateLocalized("Zoom 10");
  zoom_menu = XmVaCreateSimplePulldownMenu(options_menu, "zoommenu", 
      2, zoom_cb,
      XmNradioBehavior,True,
      XmVaRADIOBUTTON, show_all, 'a', "Ctrl<Key>a", NULL,
      XmVaSEPARATOR,
      XmVaRADIOBUTTON, zoom1, '1', "Ctrl<Key>1", NULL,
      XmVaRADIOBUTTON, zoom2, '2', "Ctrl<Key>2", NULL,
      XmVaRADIOBUTTON, zoom3, '3', "Ctrl<Key>3", NULL,
      XmVaRADIOBUTTON, zoom4, '4', "Ctrl<Key>4", NULL,
      XmVaRADIOBUTTON, zoom5, '5', "Ctrl<Key>4", NULL,
      XmVaRADIOBUTTON, zoom6, '6', "Ctrl<Key>6", NULL,
      XmVaRADIOBUTTON, zoom10, '0', "Ctrl<Key>0", NULL,
      NULL);
  XmToggleButtonSetState(XtNameToWidget(zoom_menu,"button_0"),XmSET,True);

  XmStringFree(show_all);
  XmStringFree(zoom1);
  XmStringFree(zoom2);
  XmStringFree(zoom3);
  XmStringFree(zoom4); 
  XmStringFree(zoom6);
  XmStringFree(zoom10);

  /* Create pulldown menu for ROI
   */
  draw     = XmStringCreateLocalized("Draw");
  tools    = XmStringCreateLocalized("Tools");
  file     = XmStringCreateLocalized("File");
  save_roi_to = XmStringCreateLocalized("Save in");
  list     = XmStringCreateLocalized("List..."); 
  showinmatrix = XmStringCreateLocalized("Show in matrix view");
  smoothroi = XmStringCreateLocalized("Smooth scaling");
  roi_menu = XmVaCreateSimplePulldownMenu (menubar, "roimenu",2, 
         roi_menu_cb,
         XmVaCASCADEBUTTON, draw,   'd', 
	 XmVaCASCADEBUTTON, tools,  't',
         XmVaCASCADEBUTTON, file,   'f' ,
	 XmVaCASCADEBUTTON, save_roi_to, 0,
         XmVaSEPARATOR,
         XmVaPUSHBUTTON, list, 'l', NULL, NULL,
         XmVaSEPARATOR,
	 XmVaTOGGLEBUTTON, showinmatrix, 0, NULL,NULL,
	 XmVaTOGGLEBUTTON, smoothroi, 0, NULL,NULL,
	 NULL);
  XtSetSensitive(XtNameToWidget(roi_menu,"button_0"),False);
  XtSetSensitive(XtNameToWidget(roi_menu,"button_1"),False);
  if(panels.smoothroi)
      XmToggleButtonSetState(XtNameToWidget(roi_menu,"button_6"),XmSET,False);
  
  XmStringFree(draw);
  XmStringFree(tools);
  XmStringFree(file);
  XmStringFree(save_roi_to);
  XmStringFree(list);
  XmStringFree(showinmatrix);
  XmStringFree(smoothroi);


  /* Create pulldown menu for ROI-draw button 
   */
  trace      = XmStringCreateLocalized("Trace");
  rectangle  = XmStringCreateLocalized("Rectangle");
  circle     = XmStringCreateLocalized("Circle");
  ellipse    = XmStringCreateLocalized("Ellipse");
  draw_menu  = XmVaCreateSimplePulldownMenu(roi_menu, "drawmenu", 
    0, roi_draw_cb,
    XmVaPUSHBUTTON, trace,      'T', "Ctrl<Key>t", NULL,
    XmVaPUSHBUTTON, rectangle , 'R', "Ctrl<Key>r", NULL,
    XmVaPUSHBUTTON, circle,     'C', "Ctrl<Key>c", NULL,
    XmVaPUSHBUTTON, ellipse,    'E', "Ctrl<Key>e", NULL,
    NULL);
  XmStringFree(trace);
  XmStringFree(rectangle);
  XmStringFree(circle);
  XmStringFree(ellipse);
  /* Create pulldown menu for ROI-tools button 
   */
  move       = XmStringCreateLocalized("Move");
  copy       = XmStringCreateLocalized("Copy...");
  mirror_copy= XmStringCreateLocalized("Mirror copy...");
  doubling     = XmStringCreateLocalized("Double");
  convertroi = XmStringCreateLocalized("Convert to trace");
  rotate     = XmStringCreateLocalized("Rotate");
  profile    = XmStringCreateLocalized("Profile");
  roitools_menu  = XmVaCreateSimplePulldownMenu(roi_menu, "toolsmenu", 
    1, roi_tools_cb,
    XmVaPUSHBUTTON, move,       'M', "Ctrl<Key>m", NULL,
    XmVaPUSHBUTTON, copy,       'c', NULL, NULL,
    XmVaPUSHBUTTON, mirror_copy,'m', NULL, NULL,
    XmVaPUSHBUTTON, doubling ,    'D',"Ctrl<Key>d", NULL,
    XmVaPUSHBUTTON, convertroi, 0, NULL,NULL,
    XmVaPUSHBUTTON, rotate,     'r', NULL, NULL,
    XmVaPUSHBUTTON, profile,	'p',NULL,NULL,
    NULL);
  XmStringFree(rotate);
  XmStringFree(convertroi);
  XmStringFree(move);
  XmStringFree(copy);
  XmStringFree(mirror_copy);
  XmStringFree(doubling);
  XmStringFree(profile);

  /* Create pulldown menu for ROI-file button 
   */
  save_roi  = XmStringCreateLocalized("Save ROI...");
  retrieve  = XmStringCreateLocalized("Load ROI..."); 
  file_menu = XmVaCreateSimplePulldownMenu(roi_menu, "roifilemenu", 
     2, roi_file_cb,
     XmVaPUSHBUTTON, save_roi, 'S', "Ctrl<Key>s", NULL, 
     XmVaPUSHBUTTON, retrieve, 'L', "Ctrl<Key>l", NULL, 
     NULL);
  XmStringFree(save_roi);
  XmStringFree(retrieve);
  /* Create pulldown menu for save-ROI-to button
   */
  roi_1st = XmStringCreateLocalized("1st study");
  roi_2nd = XmStringCreateLocalized("2nd study");
  roisavemenu = XmVaCreateSimplePulldownMenu(roi_menu, "roisavetomenu", 
     3, roi_saveto_cb,
     XmNradioBehavior,True,
     XmVaRADIOBUTTON, roi_1st, 0, NULL, NULL,
     XmVaRADIOBUTTON, roi_2nd, 0, NULL, NULL,
     NULL);
  XmToggleButtonSetState(XtNameToWidget(roisavemenu,panels.save_roi_studyn?"button_1":"button_0"),XmSET,False);
  XmStringFree(roi_1st);
  XmStringFree(roi_2nd);

  /* Create pulldown menu for Help-button 
   */
  usage = XmStringCreateLocalized("Usage");
  about = XmStringCreateLocalized("About YaIT...");
  help_menu = XmVaCreateSimplePulldownMenu(menubar, "helpmenu", 3, helpmenu_cb,
    XmVaPUSHBUTTON, usage, 'U', "Ctrl<Key>u", NULL,
    XmVaPUSHBUTTON, about, 'Y', "Ctrl<Key>y", NULL,
    NULL);
  XmStringFree(usage);
  XmStringFree(about);


  XtManageChild (color_menu);
  XtManageChild (color2_menu);
  XtManageChild (color_m);
  XtManageChild (scale_menu);
  XtManageChild (zoom_menu);
  XtManageChild (interpolation_menu);
  XtManageChild (options_menu);
  XtManageChild (draw_menu);
  XtManageChild (file_menu);
  XtManageChild (roi_menu);
  XtManageChild (help_menu);
 
  if((widget = XtNameToWidget(menubar, "button_3")) != (Widget)0)
    XtVaSetValues(menubar, XmNmenuHelpWidget, widget, NULL);
}

