#include <stdio.h>
#include <stdlib.h>
#include <Xm/Xm.h>
#include <Xm/Text.h>
#include <Xm/List.h>
#include <Xm/SelectioB.h>
#include <Xm/MessageB.h>
#include "main.h"

#include "help_cb.h"
#include "file_cb.h"
#include "util.h"
#include "message_dialog.h"

static void quit_cb(Widget dialog, XtPointer client_data, XtPointer call_data);

void message_dialog(char *message,char *title)
{
  Widget  dialog;
  XmString       t,ttl; 
  Arg args[5];
  int n = 0;
  
   XtSetArg(args[n], XmNautoUnmanage, False); n++;
   dialog = XmCreateInformationDialog (toplevel, "message", args, n);

   XtAddCallback (dialog, XmNokCallback, unmanage_cb, NULL );

   XtUnmanageChild (XtNameToWidget (dialog, "Cancel"));
   XtUnmanageChild (XtNameToWidget (dialog, "Help"));
         
   t  = XmStringCreateLocalized(message);
   ttl= XmStringCreateLocalized(title);
   XtVaSetValues (dialog,
   	XmNmessageString, t,
	XmNdialogTitle, ttl,
	NULL);
   XmStringFree (t);
   XmStringFree (ttl);
   XtManageChild (dialog);

}

void info_dialog(char *message, char *title,int index)
{
  Widget         dialog;
  XmString       t,ttl;
  Arg            args[5];
  int            n = 0;
  
   XtSetArg(args[n], XmNautoUnmanage, False); n++;
   dialog = XmCreateQuestionDialog (toplevel, "message", args, n);
   switch(index){
     case 1: XtAddCallback(dialog, XmNokCallback, clear_again, NULL); break;
     case 2: XtAddCallback(dialog, XmNokCallback, quit_cb, NULL); break; 
     default: break;
   }   
   XtAddCallback (dialog, XmNcancelCallback,  unmanage_cb, NULL );

#if 0
   XtUnmanageChild (XtNameToWidget (dialog, "Cancel"));
   XtUnmanageChild (XtNameToWidget (dialog, "Help"));
#endif
         
   t  = XmStringCreateLocalized(message);
   ttl= XmStringCreateLocalized(title);
   XtVaSetValues (dialog,
   	XmNmessageString,t,
	XmNdialogTitle,ttl,
	NULL);
   XmStringFree (t);
   XmStringFree (ttl);
   XtManageChild (dialog);


}


void error_dialog(char *message)
{
  Widget  dialog;
  XmString       t,ttl;
  Arg args[1];
  int n = 0;
  
   XtSetArg(args[n], XmNautoUnmanage, False); n++;
   dialog = XmCreateInformationDialog (toplevel, "error", args, n);

   XtAddCallback (dialog, XmNokCallback, unmanage_cb, NULL );

   XtUnmanageChild (XtNameToWidget (dialog, "Cancel"));
   XtUnmanageChild (XtNameToWidget (dialog, "Help"));
         
   t = XmStringCreateLocalized(message);
   ttl =XmStringCreateLocalized("Error");
   XtVaSetValues (dialog, XmNmessageString, t,XmNdialogTitle,ttl, NULL);
   XmStringFree (t);
   XmStringFree (ttl);
   XtManageChild (dialog);

}

void fatal_error_dialog(char *message) {
  Widget dialog;
  XmString t,ttl,ok,cancel;
  Arg args[5];
  int n=0;
  XtSetArg(args[n],XmNautoUnmanage,False); n++;
  dialog=XmCreateErrorDialog(toplevel,"fatalerror",args,n);
  t=XmStringCreateLocalized(message);
  ttl=XmStringCreateLocalized("Fatal error !");
  ok=XmStringCreateLocalized("Quit");
  cancel=XmStringCreateLocalized("Attempt to continue");
  XtVaSetValues(dialog,XmNmessageString,t,
  	XmNdialogTitle,ttl,
  	XmNokLabelString,ok,
	XmNcancelLabelString,cancel,
	XmNdialogStyle,XmDIALOG_FULL_APPLICATION_MODAL,
	NULL);
  XtAddCallback (dialog, XmNcancelCallback, unmanage_cb, dialog );
  XtAddCallback (dialog, XmNokCallback, quit_cb, NULL );
  XtAddCallback (dialog,XmNhelpCallback,help_cb,"A fatal error occured and the program cannot continue functioning properly.\nYou have a choice to try to continue so you can save your work.");
  XmStringFree(t);
  XmStringFree(ok);
  XmStringFree(cancel);
  XmStringFree(ttl);
  XtManageChild(dialog);
}
void quit_dialog(char *message)
{
  Widget  dialog;
  XmString t,ttl;
  Arg args[5];
  int n = 0;
 
  dialog = XmCreateQuestionDialog (toplevel, "quit", args, n);
  XtAddCallback (dialog, XmNokCallback,  quit_cb, NULL );
  XtAddCallback (dialog, XmNcancelCallback,  unmanage_cb, NULL );
  
  XtUnmanageChild (XtNameToWidget (dialog, "Help"));
         
  t = XmStringCreateLocalized(message);
  ttl = XmStringCreateLocalized("Quit ?");
  XtVaSetValues (dialog, XmNmessageString, t,XmNdialogTitle,ttl, NULL);
  XmStringFree (t);
  XmStringFree (ttl);

  XtManageChild (dialog);

}

static void quit_cb (Widget dialog, XtPointer client_data, XtPointer call_data)
{
      XtUnmanageChild (dialog); 
      exit(0);
}



