#include <stdio.h>
#include <string.h>
#include <time.h>
#include "main.h"
#include "roiutils.h"
#include "deviation.h"
#include "message_dialog.h"
#include "move_roi.h"
#include "cursor.h"
#include "zoom_images.h"

void move_roi_cb(Widget w, XtPointer client_data, XtPointer call_data) {
  XButtonEvent *event=call_data;
  static int x=-1,y=-1;
  ROI *roi;
  if(x<0 && client_data==NULL) {
    XtVaGetValues(w,petimageNselectedRoi,&roi,NULL);
    if(roi==NULL) {
      set_ROI_drawmode(NULL,-1);
      message_dialog("Please select a ROI first","Move ROI");
      return;
    }
    PetimageHighlightRoi((PetimageWidget)w,roi,ROI_MOVE);
    x=event->x;
    y=event->y;
    my_SetMoveCursor(w);
  } else {
    if(event->button!=Button3) {
      ROI_list *rois;
      int zoom;
      float f;
      if(client_data) {
        x=((move_roi_clientdata*)client_data)->x;
        y=((move_roi_clientdata*)client_data)->y;
      }
      XtVaGetValues(w,
	petimageNROI,&rois,
	petimageNselectedRoi,&roi,
	petimageNzoom,&zoom,
	NULL);
      f=roi->zoom/zoom;
      roi->pos_x-=(x-event->x)*f;
      roi->pos_y-=(y-event->y)*f;
      /* Calculate CoV inside of ROI
      */
      calc_dev(&studies[0].imagepack,roi->matnum, roi, &((roi_userdata*)roi->userdata)->mean, &((roi_userdata*)roi->userdata)->dev);
      XtVaSetValues(w,petimageNrequestRoi,roi,NULL);
      /* Finish up */
    }
    x=-1;
    y=-1;
    PetimageEndRoiDraw((PetimageWidget)w);
    set_ROI_drawmode(NULL,-1);
    PetimageUpdate(get_zoom_image()->widget[0]);
    PetimageUpdate(get_zoom_image()->widget[1]);
  }
}


