#include <stdio.h>
#include <Xm/Xm.h>
#include <Xm/SelectioB.h>
#include "main.h"
#include "close_file.h"
#include "cursor.h"
#include "file_cb.h"
#include "read_arg.h"
#include "help_cb.h"
#include "zoom_images.h"

void options_cb(Widget w, XtPointer client_data, XtPointer call_data)
{
  int                      item_no = (int)client_data;
  Arg                      args[5];
  int                      n = 0;
  Widget                   dialog;
  XmString                 frames,title;
  my_SetWatchCursor(toplevel);

  switch(item_no){
    case 3:
    case 4:
      printf("options_cb(): select%s again\n",item_no==4?" (secondary)":"");
      if(strlen(studies[0].filename)<4) break;

      /* Here goes how the frames, planes and gates are chosen.
       * Remember to allocate memory. */
      n=0;
      frames =XmStringCreateLocalized("Select matrixes:");
      title = XmStringCreateLocalized(item_no==3?"Load matrices":"Load secondary matrices");
      XtSetArg(args[n], XmNselectionLabelString, frames); n++;
      XtSetArg(args[n], XmNdialogTitle, title); n++;
      dialog =XmCreatePromptDialog(toplevel, "matrix_selection",args,n);
      XmStringFree(frames);
      XmStringFree(title);

      /* When the user types frame, plane and gate, call read_me()*/
      XtAddCallback(dialog, XmNokCallback, re_read_arg, &studies[item_no==4]);
      /* If the user selects cancel, just destroy the dialog */
      XtAddCallback(dialog, XmNcancelCallback, destroy_widget,NULL);
      /* Help */
      XtAddCallback(dialog, XmNhelpCallback, help_cb,
	"Select matrices eg. 1-5 8,10-15\n\
	The 1-5 tells YaIT to load planes 1 to 5 and\n\
	8,10-15 to load from those frames, planes 8 and 10 to 15.");
   
      XtManageChild(dialog);
      break;
    default: break;
  }
 
  my_ResetCursor(toplevel);
}

