#ifndef PETIMAGE_H
#define PETIMAGE_H

#include <Xm/Xm.h>
#include <roi.h>

externalref WidgetClass petimageWidgetClass;

typedef struct _petimageClassRec *PetimageWidgetClass;
typedef struct _petimageRec *PetimageWidget;

#define petimageNimage  	"image"			/* The XImage which is shown on the widget */
#define petimageNframe		"frame"			/* Frame number */
#define petimageNplane		"plane"			/* Plane number */
#define petimageNstudy		"study"			/* Study number */
#define petimageNselected 	"selected"		/* Is the widget selected or not (special petimagewidget specific selection) */
#define petimageNselectedCb	"selectedCallback"	/* Selected callback (left mousebutton press) */
#define petimageNroiSelectedCb	"roiSelectedCallback"	/* Roi selected callback */
#define petimageNmouseCb	"mouseCallback"		/* Mouse callback (other mouse buttons */
#define petimageNroiCommandCb	"roiCmdCb"		/* Roi manipulation was requested */
#define petimageNhoverCb	"hoverCb"		/* Mouse moves over petimage */
#define petimageNframeColor	"frameColor"		/* Color of the selection frame */
#define petimageNROI		"ROI"			/* ROI_list. Shows the ROIs that have the same frame/plane number as this widget */
#define petimageNzoom		"zoom"			/* Zoom multiplier */
#define petimageNroiMode	"roiMode"		/* Roi drawing mode */
#define petimageNselectedRoi	"selectedRoi"		/* Currently selected ROI */
#define petimageNrequestRoi	"requestRoi"		/* Call the roiSelectedCallback with this ROI */
#define petimageNroiColor	"roiColor"		/* Color with which the ROIs are drawn */
#define petimageNselRoiColor	"selRoiColor"		/* Selected ROIs color */

#define petimageCimage		"image"
#define petimageCframe		"frame"
#define petimageCplane		"plane"
#define petimageCstudy		"study"
#define petimageCselected	"selected"
#define petimageCselectedCb	"selectedCallback"
#define petimageCroiSelectedCb	"roiSelectedCallback"
#define petimageCmouseCb	"mouseCallback"
#define petimageCroiCommandCb	"roiCmdCb"
#define petimageChoverCb	"hoverCb" 
#define petimageCframeColor	"frameColor"
#define petimageCROI		"ROI"
#define petimageCzoom		"zoom"
#define petimageCroiMode	"roiMode"
#define petimageCselectedRoi	"selectedRoi"
#define petimageCrequestRoi	"requestRoi"
#define petimageCroiColor	"roiColor"
#define petimageCselRoiColor	"selRoiColor"

#define IsPetimage(w) XtIsSubclass((w),petimageWidgetClass)

/* Redraw the widget */
extern void PetimageUpdate(PetimageWidget w);

/* Set a point in ROI drawing mode */
extern void PetimageSetRoiDrawPoint(PetimageWidget w,int x,int y);

/* End ROI drawing. (in case of Trace ROI, joins the last and first point) */
extern void PetimageEndRoiDraw(PetimageWidget w);

/* Copy an existing ROI to ROI draw buffer so it can be moved and such */
extern void PetimageHighlightRoi(PetimageWidget w,ROI *roi,int mode);

/* Delete Lego ROI from Petimage buffer */
extern void PetimageFlush(PetimageWidget w);

#endif

