#ifndef PETIMAGEP_H
#define PETIMAGEP_H

#include <Xm/XmP.h>
#include <Xm/PrimitiveP.h>
#include "petimage.h"

#define PetimageIndex (XmPrimitiveIndex + 1)

typedef struct _PetimageRoiPoint {
  int x,y;
  struct _PetimageRoiPoint *prev,*next;
} PetimageRoiPoint;

typedef struct _PetimageClassPart {
    int reserved;
} PetimageClassPart;

typedef struct _PetimageClassRec {
    CoreClassPart core_class;
    XmPrimitiveClassPart primitive_class;
    PetimageClassPart petimage_class;
} PetimageClassRec;

extern PetimageClassRec petimageClassRec;

typedef struct _PetimagePart {
  XtCallbackList selected_callback;
  XtCallbackList mouse_callback;
  XtCallbackList roi_selected_callback;
  XtCallbackList roi_cmd_callback;
  XtCallbackList hover_callback;
  GC draw_GC;
  GC xor_GC;
  PetimageRoiPoint *roi_preview;
  int roimode;
  XImage *image;
  XImage *lego_roi;
  int frame,plane,numcod,study;
  int selected;
  int framecolor;
  ROI_list *rois;
  ROI *selectedRoi;
  ROI *requestRoi;
  int roiColor;
  int selRoiColor;
  int zoom;
  int tmpX,tmpY;
  double tmpD,tmpD2;
} PetimagePart;

typedef struct _PetimageRec {
  CorePart core;
  XmPrimitivePart primitive;
  PetimagePart petimage;
} PetimageRec;

#endif

