#include <stdio.h>
#include <stdlib.h>
#include <Xm/Xm.h>
#include <Xm/TextF.h>
#include "petimage.h"
#include "colormap.h"
#include "main.h"
#include "message_dialog.h"
#include "cursor.h"
#include "images.h"
#include "zoom_images.h"
#include "export.h"
#include "print.h"

#define HEADER_HEIGHT 40

static void ximage2ps(XImage *src,FILE *fp,int cmapN);
static void print_zoom_image(PaperOrientation orientation,int paperw,int paperh,FILE *fp);
static void print_matrix(PaperOrientation orientation,int paperw,int paperh,int marginleft,int margintop,int marginright,int marginbottom,Boolean header,FILE *fp);
static void print_header(int page,int x,int y,int width,FILE *fp);

void print_to_file(char *filename,PaperOrientation orientation,int paperw,int paperh,double top,double bottom,double left,double right,Boolean header) {
  int mtop,mbottom,mleft,mright;
  FILE *fp;

  fp=fopen(filename,"w");
  if(!fp) {
    fprintf(stderr,"print_to_file(\"%s\",%d,%d): Cannot open file for writing !\n",filename,paperw,paperh);
    error_dialog("Cannot open PostScript file for writing !");
    return;
  }
  fprintf(fp,"%%!PS-Adobe-2.0\n%%%%Creator: %s using YaIT %s\n",getenv("USER"),YAIT_VER);
  fprintf(fp,"%%%%Pages: (atend)\n");
  if(orientation==PaperLandscape) {
    int tmp;
    fprintf(fp,"%%%%Orientation: Landscape\n");
    tmp=paperw;
    paperw=paperh;
    paperh=tmp;
  } else {
    fprintf(fp,"%%%%Orientation: Portrait\n");
  }
  fprintf(fp,"/#copies 1 def\n");
  if(header) fprintf(fp,"/Times-Roman findfont\n12 scalefont\nsetfont\n");
  /* Print document */
  if(zoom_matrix.zoom>0) {
    print_zoom_image(orientation,paperw,paperh,fp);
  } else {
    mtop=top*72.0;
    mleft=left*72.0;
    mbottom=bottom*72.0;
    mright=right*72.0;
    paperw-=mleft+mright;
    paperh-=mtop+mbottom;
    print_matrix(orientation,paperw,paperh,mleft,mtop,mright,mbottom,header,fp);
  }
  fprintf(fp,"%%%%EOF\n");
  fclose(fp);
}

static void print_zoom_image(PaperOrientation orientation,int paperw,int paperh,FILE *fp) {
  ExportOptions opt;
  XImage *image;
  opt.spacing=0;
  opt.imagesPerRow=2;
  image=export_to_ximage(opt);
  if(orientation==PaperLandscape) { /* BUG: larger images are not centered properly */
    int movex,movey;
    movex=paperh/2+image->width/2;
    movey=paperw/2-image->height/2;
    fprintf(fp,"90 rotate\n%d -%d translate\n",movex,movey);
  } else {
    fprintf(fp,"%d %d translate\n",paperw/2-image->width/2,paperh/2-image->height/2);
  }
  ximage2ps(image,fp,-1);
  XDestroyImage(image);
}

static void print_matrix(PaperOrientation orientation,int paperw,int paperh,int marginleft,int margintop,int marginright,int marginbottom,Boolean header,FILE *fp) {
  ImageList *list;
  int x=0,y=paperh,iperr,iperp,pos=1,rows=0;
  int page=1,pageopen=0;
  char line[32];
  memset(line,0,32);
  list=get_image_list();
  iperr=paperw/list->img->image->width;
  iperp=(paperh-(header?HEADER_HEIGHT:0))/list->img->image->height;
  memset(line,'-',iperr*4);
  if(strlen(studies[1].filename)>4 && iperr%2 && iperr>2) iperr--;
  if(orientation==PaperLandscape)
    y+=list->img->image->width;
  else
    y-=list->img->image->width;
  printf("Matrix print preview (%d images per row, %d rows per page)\n",iperr,iperp);
  while(list) {
    if(pageopen==0) { /* Open a new page */
      fprintf(fp,"%%%%Page: %d %d\n/saveobj save def\n",page,page);
      if(orientation==PaperLandscape)
        fprintf(fp,"90 rotate\n0 -%d translate\n",paperw+margintop+marginbottom);
      fprintf(fp,"%d %d translate\n",marginleft,margintop);
      if(header) {
        print_header(page,0,orientation==PaperLandscape?paperw:paperh,paperw,fp);
	y-=HEADER_HEIGHT;
      }
      printf("/%s\\\n",line);
      pageopen=1;
    }
    printf(" [%d]",list->img->studyN+1);
    /* Print out the image */
    fprintf(fp,"gsave\n");
    fprintf(fp,"%d %d translate\n",x,y);
    ximage2ps(list->img->image,fp,list->img->studyN);
    x+=list->img->image->width;
    fprintf(fp,"grestore\n");
    if(pos==iperr) { /* Line break */
      pos=1;
      x=0;
      y-=list->img->image->height;
      rows++;
      printf("\n");
    } else pos++;
    if(rows==iperp) { /* Page break */
      pos=1;
      x=0;
      if(orientation==PaperLandscape)
        y=paperh+list->img->image->width;
      else
        y=paperh-list->img->image->width;
      rows=0;
      fprintf(fp,"saveobj restore\nshowpage\n");
      pageopen=0;
      page++;
      printf("\\%s/\n",line);
    } 
    list=list->next;
  }
  if(pageopen) {
    fprintf(fp,"saveobj restore\nshowpage\n");
    if(pos>1) printf("\n");
    printf("\\%s/\n",line);
  }
  fprintf(fp,"%%%%Trailer\n");
  fprintf(fp,"%%%%Pages: %d\n",page);
  printf("%d Pages.\n",page);
}

static void ximage2ps(XImage *src,FILE *fp,int cmapN) {
  unsigned char *ptr=src->data;
  int x,y;
  fprintf(fp,"%d %d scale\n",src->width,src->height);
  fprintf(fp,"%d %d 8 [%d 0 0 -%d 0 %d]\n",src->width,src->height,src->width,src->height,src->width);
  fprintf(fp,"{currentfile 3 %d mul string readhexstring pop} bind\n",src->width);
  fprintf(fp,"false 3 colorimage\n");
  if(cmapN<0) {
    for(y=0;y<src->height;y++) {
      for(x=0;x<src->width;x++,ptr++) {
        unsigned char val;
	val=*ptr;
	if(val>PALETTE_COLORS) {val-=PALETTE_COLORS; cmapN=1;} else cmapN=0;
        fprintf(fp,"%.2x%.2x%.2x",yait_palette[cmapN][val].red>>8,yait_palette[cmapN][val].green>>8,yait_palette[cmapN][val].blue>>8);
      }
      fputc('\n',fp);
    }
  } else {
    for(y=0;y<src->height;y++) {
      for(x=0;x<src->width;x++,ptr++)
        fprintf(fp,"%.2x%.2x%.2x",yait_palette[cmapN][*ptr].red>>8,yait_palette[cmapN][*ptr].green>>8,yait_palette[cmapN][*ptr].blue>>8);
      fputc('\n',fp);
    }
  }
}

static void print_header(int page,int x,int y,int width,FILE *fp) {
  char *filename;
  filename=strrchr(studies[0].filename,'/');
  if(filename==NULL) filename=studies[0].filename; else filename++;
  fprintf(fp,"newpath\n");
  fprintf(fp,"%d %d moveto\n(Study 1: %s) show\n",x,y,filename);
  fprintf(fp,"%d %d moveto\n(Page %d) show\n",width-50,y,page);
  y-=15;
  if(strlen(studies[1].filename)>4) {
    filename=strrchr(studies[1].filename,'/');
    if(filename==NULL) filename=studies[1].filename; else filename++;
    fprintf(fp,"%d %d moveto\n(Study 2: %s) show\n",x,y,filename);
  }
  y-=14;
  fprintf(fp,"0 %d moveto\n%d %d lineto\n",y,width,y);
  fprintf(fp,"2 setlinewidth\nstroke\n");
}

